/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.internal;

import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.enums.CheckRule;
import eu.tsystems.mms.tic.testframework.internal.asserts.AbstractPropertyAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.AssertionProvider;
import eu.tsystems.mms.tic.testframework.internal.asserts.BinaryAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultBinaryAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultStringAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.ImageAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.PropertyAssertionConfig;
import eu.tsystems.mms.tic.testframework.internal.asserts.PropertyAssertionFactory;
import eu.tsystems.mms.tic.testframework.internal.asserts.StringAssertion;
import eu.tsystems.mms.tic.testframework.pageobjects.Page;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.AbstractPage;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.DefaultImageAssertion;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.DefaultRectAssertion;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.PageAssertions;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.RectAssertion;
import eu.tsystems.mms.tic.testframework.report.Report;
import eu.tsystems.mms.tic.testframework.report.model.context.Screenshot;
import eu.tsystems.mms.tic.testframework.report.utils.ExecutionContextController;
import eu.tsystems.mms.tic.testframework.utils.JSUtils;
import eu.tsystems.mms.tic.testframework.utils.UITestUtils;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;

public class DefaultPageAssertions
implements PageAssertions {
    private static final PropertyAssertionFactory propertyAssertionFactory = (PropertyAssertionFactory)Testerra.getInjector().getInstance(PropertyAssertionFactory.class);
    private static final Report report = (Report)Testerra.getInjector().getInstance(Report.class);
    private final PropertyAssertionConfig propertyAssertionConfig;
    private final AbstractPage page;

    public DefaultPageAssertions(Page page, PropertyAssertionConfig config) {
        this.page = page;
        this.propertyAssertionConfig = config;
    }

    @Override
    public StringAssertion<String> title() {
        return (StringAssertion)propertyAssertionFactory.createWithConfig(DefaultStringAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new AssertionProvider<String>(){

            public String getActual() {
                return DefaultPageAssertions.this.page.getWebDriver().getTitle();
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultPageAssertions.this.page.toString(), "title=" + AssertionProvider.Format.shortString((Object)this.getActual())});
            }
        });
    }

    @Override
    public StringAssertion<String> url() {
        return (StringAssertion)propertyAssertionFactory.createWithConfig(DefaultStringAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new AssertionProvider<String>(){

            public String getActual() {
                return DefaultPageAssertions.this.page.getWebDriver().getCurrentUrl();
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultPageAssertions.this.page.toString(), "url=" + AssertionProvider.Format.param((Object)this.getActual())});
            }
        });
    }

    @Override
    public BinaryAssertion<Boolean> displayed() {
        return (BinaryAssertion)propertyAssertionFactory.createWithConfig(DefaultBinaryAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new AssertionProvider<Boolean>(){

            public Boolean getActual() {
                try {
                    DefaultPageAssertions.this.page.checkUiElements(CheckRule.IS_DISPLAYED);
                    return true;
                }
                catch (Throwable e) {
                    return false;
                }
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultPageAssertions.this.page.toString(), "displayed"});
            }
        });
    }

    @Override
    public BinaryAssertion<Boolean> present() {
        return (BinaryAssertion)propertyAssertionFactory.createWithConfig(DefaultBinaryAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new AssertionProvider<Boolean>(){

            public Boolean getActual() {
                try {
                    DefaultPageAssertions.this.page.checkUiElements(CheckRule.IS_PRESENT);
                    return true;
                }
                catch (Throwable e) {
                    return false;
                }
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultPageAssertions.this.page.toString(), "present"});
            }
        });
    }

    @Override
    public RectAssertion viewport() {
        return (RectAssertion)propertyAssertionFactory.createWithConfig(DefaultRectAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new AssertionProvider<Rectangle>(){

            public Rectangle getActual() {
                return new JSUtils().getViewport(DefaultPageAssertions.this.page.getWebDriver());
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultPageAssertions.this.page.toString(), "viewport"});
            }
        });
    }

    private static void addScreenshotToReport(Screenshot screenshot) {
        report.addScreenshot(screenshot, Report.FileMode.COPY);
        ExecutionContextController.getCurrentMethodContext().addScreenshot(screenshot);
    }

    public ImageAssertion screenshot(Report.Mode reportMode) {
        Screenshot screenshot = new Screenshot(this.page.toString());
        final WebDriver webDriver = this.page.getWebDriver();
        UITestUtils.takeScreenshot(webDriver, screenshot);
        if (reportMode == Report.Mode.ALWAYS) {
            DefaultPageAssertions.addScreenshotToReport(screenshot);
        }
        final AtomicReference<Screenshot> atomicScreenshot = new AtomicReference<Screenshot>();
        atomicScreenshot.set(screenshot);
        return (ImageAssertion)propertyAssertionFactory.createWithConfig(DefaultImageAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new AssertionProvider<File>(){

            public File getActual() {
                return ((Screenshot)atomicScreenshot.get()).getScreenshotFile();
            }

            public void failed(AbstractPropertyAssertion assertion) {
                UITestUtils.takeScreenshot(webDriver, (Screenshot)atomicScreenshot.get());
            }

            public void failedFinally(AbstractPropertyAssertion assertion) {
                DefaultPageAssertions.addScreenshotToReport((Screenshot)atomicScreenshot.get());
            }

            public String createSubject() {
                return DefaultPageAssertions.this.page.toString();
            }
        });
    }
}

