/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.internal;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.enums.CheckRule;
import eu.tsystems.mms.tic.testframework.events.MethodEndEvent;
import eu.tsystems.mms.tic.testframework.exceptions.PageFactoryException;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.pageobjects.Component;
import eu.tsystems.mms.tic.testframework.pageobjects.Page;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.AbstractPage;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.PageFactory;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;

public class DefaultPageFactory
implements PageFactory,
MethodEndEvent.Listener,
Loggable {
    @Deprecated
    private String GLOBAL_PAGES_PREFIX = null;
    @Deprecated
    private final ThreadLocal<String> THREAD_LOCAL_PAGES_PREFIX = new ThreadLocal();
    private static final ThreadLocal<CircularFifoBuffer> LOOP_DETECTION_LOGGER = new ThreadLocal();
    private static final int NR_OF_LOOPS = PageFactory.Properties.PAGE_FACTORY_LOOPS.asLong().intValue();

    @Override
    public PageFactory setGlobalPagesPrefix(String pagePrefix) {
        this.GLOBAL_PAGES_PREFIX = pagePrefix;
        return this;
    }

    @Override
    public PageFactory setThreadLocalPagesPrefix(String pagePrefix) {
        this.THREAD_LOCAL_PAGES_PREFIX.set(pagePrefix);
        return this;
    }

    @Override
    public PageFactory clearThreadLocalPagesPrefix() {
        this.THREAD_LOCAL_PAGES_PREFIX.remove();
        return this;
    }

    public DefaultPageFactory() {
        EventBus eventBus = Testerra.getEventBus();
        eventBus.register((Object)this);
    }

    @Override
    public <T extends Page> T createPage(Class<T> pageClass, WebDriver webDriver) {
        return this.createPageWithCheckRule(pageClass, webDriver, CheckRule.DEFAULT);
    }

    private String getConfiguredPrefix() {
        String pagesPrefix = this.GLOBAL_PAGES_PREFIX;
        if (StringUtils.isNotEmpty((CharSequence)this.THREAD_LOCAL_PAGES_PREFIX.get())) {
            pagesPrefix = this.THREAD_LOCAL_PAGES_PREFIX.get();
        }
        return pagesPrefix != null ? pagesPrefix : "";
    }

    @Override
    public <T extends Component> T createComponent(Class<T> componentClass, UiElement rootElement) {
        try {
            Constructor<T> constructor = componentClass.getConstructor(UiElement.class);
            Component component = (Component)constructor.newInstance(rootElement);
            ((AbstractPage)((Object)component)).checkUiElements();
            return (T)component;
        }
        catch (Throwable throwable) {
            throw new PageFactoryException(componentClass, rootElement.getWebDriver(), throwable);
        }
    }

    @Override
    public <T extends Page> T createPageWithCheckRule(Class<T> pageClass, WebDriver webDriver, CheckRule checkRule) {
        Page page;
        try {
            String pageClassString = String.format("%s.%s%s", pageClass.getPackage().getName(), this.getConfiguredPrefix(), pageClass.getSimpleName());
            pageClass = Class.forName(pageClassString);
            Constructor<Object> constructor = pageClass.getConstructor(WebDriver.class);
            page = (Page)constructor.newInstance(webDriver);
            page.checkUiElements(checkRule);
        }
        catch (Throwable throwable) {
            throw new PageFactoryException(pageClass, webDriver, throwable);
        }
        this.runLoopDetection(pageClass);
        return (T)page;
    }

    private void runLoopDetection(Class pageClass) {
        List list;
        CircularFifoBuffer buffer = LOOP_DETECTION_LOGGER.get();
        if (buffer == null) {
            CircularFifoBuffer fifoBuffer = new CircularFifoBuffer(NR_OF_LOOPS);
            LOOP_DETECTION_LOGGER.set(fifoBuffer);
            buffer = LOOP_DETECTION_LOGGER.get();
        }
        buffer.add((Object)pageClass);
        if (buffer.size() == NR_OF_LOOPS && (list = buffer.stream().distinct().collect(Collectors.toList())).size() == 1) {
            throw new RuntimeException("PageFactory create loop detected loading: " + list.get(0));
        }
    }

    @Subscribe
    public void onMethodEnd(MethodEndEvent event) {
        this.clearLoopDetectionBuffer();
    }

    public static void clearLoopDetectionBuffer() {
        if (LOOP_DETECTION_LOGGER.get() != null) {
            LOOP_DETECTION_LOGGER.get().clear();
        }
    }
}

