/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.internal;

import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.pageobjects.Locator;
import eu.tsystems.mms.tic.testframework.pageobjects.PreparedLocator;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.XPath;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.DefaultLocator;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.DefaultPreparedLocator;
import java.util.function.Consumer;
import org.openqa.selenium.By;

public class LocatorFactory
implements Loggable {
    ThreadLocal<Consumer<Locator>> locatorConfigurator = new ThreadLocal();

    public Locator by(By by) {
        return new DefaultLocator(by);
    }

    public Locator by(XPath xPath) {
        return this.by((By)new By.ByXPath(xPath.toString()));
    }

    public Locator byQa(String string) {
        return this.by(XPath.from("*").attribute(UiElement.Properties.QA_ATTRIBUTE.asString()).is(string));
    }

    public PreparedLocator prepare(String format) {
        return new DefaultPreparedLocator(format);
    }

    public void setThreadLocalConfigurator(Consumer<Locator> consumer) {
        if (consumer != null) {
            this.locatorConfigurator.set(consumer);
            this.log().info("Using thread local configurator");
        } else {
            this.locatorConfigurator.remove();
            this.log().info("Unset thread local configurator");
        }
    }
}

