/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.internal;

import eu.tsystems.mms.tic.testframework.common.IProperties;
import eu.tsystems.mms.tic.testframework.enums.CheckRule;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.pageobjects.Component;
import eu.tsystems.mms.tic.testframework.pageobjects.Page;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.testing.TestControllerProvider;
import eu.tsystems.mms.tic.testframework.testing.WebDriverManagerProvider;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.openqa.selenium.WebDriver;

public interface PageFactory
extends WebDriverManagerProvider,
TestControllerProvider,
Loggable {
    @Deprecated
    public PageFactory setGlobalPagesPrefix(String var1);

    @Deprecated
    public PageFactory setThreadLocalPagesPrefix(String var1);

    @Deprecated
    public PageFactory clearThreadLocalPagesPrefix();

    default public <T extends Page> T createPage(Class<T> pageClass) {
        return this.createPage(pageClass, WEB_DRIVER_MANAGER.getWebDriver());
    }

    public <T extends Page> T createPage(Class<T> var1, WebDriver var2);

    default public <T extends Page> Optional<T> waitForPage(Class<T> pageClass, int seconds) {
        return this.waitForPage(pageClass, WEB_DRIVER_MANAGER.getWebDriver(), seconds);
    }

    default public <T extends Page> Optional<T> waitForPage(Class<T> pageClass, WebDriver webDriver) {
        return this.waitForPage(pageClass, webDriver, -1);
    }

    default public <T extends Page> Optional<T> waitForPage(Class<T> pageClass, WebDriver webDriver, int seconds) {
        AtomicReference atomicPage = new AtomicReference();
        CONTROL.withTimeout(seconds, () -> {
            try {
                atomicPage.set(this.createPage(pageClass, webDriver));
            }
            catch (Exception e) {
                this.log().warn("Waiting for page ended: " + e.getMessage());
            }
        });
        return Optional.ofNullable((Page)atomicPage.get());
    }

    public <T extends Component> T createComponent(Class<T> var1, UiElement var2);

    @Deprecated
    public <T extends Page> T createPageWithCheckRule(Class<T> var1, WebDriver var2, CheckRule var3);

    public static enum Properties implements IProperties
    {
        PAGE_FACTORY_LOOPS("tt.page.factory.loops", 20);

        private final String property;
        private final Object defaultValue;

        private Properties(String property, Object defaultValue) {
            this.property = property;
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return this.property;
        }

        public Object getDefault() {
            return this.defaultValue;
        }
    }
}

