/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.internal;

import eu.tsystems.mms.tic.testframework.exceptions.NotYetImplementedException;
import eu.tsystems.mms.tic.testframework.exceptions.SystemException;
import eu.tsystems.mms.tic.testframework.pageobjects.PageObject;
import eu.tsystems.mms.tic.testframework.utils.JSUtils;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponsiveClassFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponsiveClassFinder.class);
    private static final String SCHEMA_DIV = "_";
    private static final String KEYWORD_PIXEL = "px";
    private static final String KEYWORD_RES = "Res";
    private static final String KEYWORD_MIN = "Min";
    private static final String KEYWORD_MAX = "Max";
    private static final String RESOLUTION_REGEX = "\\d+px";
    private static final String PATTERN_LOW = "_Min_\\d+px";
    private static final String PATTERN_MID = "_\\d+px_\\d+px";
    private static final String PATTERN_HI = "_\\d+px_Max";
    private static final String PATTERN_RES = "TODO";
    private static final Reflections reflections = new Reflections((Configuration)ResponsiveClassFinder.filter(ResponsiveClassFinder.configure()));

    private ResponsiveClassFinder() {
    }

    static ConfigurationBuilder configure() {
        return new ConfigurationBuilder().setUrls(ClasspathHelper.forJavaClassPath());
    }

    static ConfigurationBuilder filter(ConfigurationBuilder configuration) {
        configuration.setScanners(new Scanner[]{new SubTypesScanner()});
        configuration.useParallelExecutor();
        return configuration;
    }

    private static <T extends PageObject> void findSubPagesOf(Class<T> baseClass, String prefix) {
        LOGGER.debug(String.format("Searching for subtypes of class <%s>", baseClass));
        if (prefix == null) {
            prefix = "";
        }
        String baseClassName = baseClass.getSimpleName();
        PrioritizedClassInfos<T> prioritizedClassInfos = new PrioritizedClassInfos<T>();
        if (!Modifier.isAbstract(baseClass.getModifiers())) {
            prioritizedClassInfos.setBaseClass(baseClass);
        }
        Set subClasses = reflections.getSubTypesOf(baseClass);
        for (Class subClass : subClasses) {
            String classname = subClass.getSimpleName();
            if (Modifier.isAbstract(subClass.getModifiers())) {
                LOGGER.debug("Not taking " + classname + " into consideration, because it is abstract");
                continue;
            }
            ResponsiveClassFinder.tryToFindImplementationOf(subClass, classname, baseClassName, prefix, prioritizedClassInfos);
        }
        Caches.setCache(baseClass, prefix, prioritizedClassInfos);
    }

    private static <T extends PageObject> void tryToFindImplementationOf(Class<T> subClass, String classname, String baseClassName, String prefix, PrioritizedClassInfos<T> prioritizedClassInfos) {
        String resPart;
        if (classname.startsWith(prefix + baseClassName)) {
            String resPart2 = classname.replace(prefix + baseClassName, "");
            if (ResponsiveClassFinder.matchesOurAnyOfPatterns(resPart2)) {
                prioritizedClassInfos.getPrefixedClasses().add(new ResolutionClassInfo<T>(subClass, resPart2));
            } else if (StringUtils.isBlank((CharSequence)resPart2)) {
                prioritizedClassInfos.setPrefixedBaseClass(subClass);
            }
        } else if (classname.startsWith(baseClassName) && ResponsiveClassFinder.matchesOurAnyOfPatterns(resPart = classname.replace(baseClassName, ""))) {
            prioritizedClassInfos.getNonPrefixedClasses().add(new ResolutionClassInfo<T>(subClass, resPart));
        }
    }

    private static boolean matchesOurAnyOfPatterns(String resPartOfClassName) {
        if (StringUtils.isBlank((CharSequence)resPartOfClassName)) {
            return false;
        }
        return resPartOfClassName.matches(PATTERN_LOW) || resPartOfClassName.matches(PATTERN_MID) || resPartOfClassName.matches(PATTERN_HI) || resPartOfClassName.matches(PATTERN_RES);
    }

    private static int getBrowserViewportSize(WebDriver driver, int viewportWidth) {
        if (viewportWidth > 0) {
            return viewportWidth;
        }
        Object o = JSUtils.executeScript(driver, "return window.innerWidth", new Object[0]);
        if (o instanceof Long) {
            int viewportWidthNew = (int)((Long)o).longValue();
            LOGGER.debug(String.format("Browser viewport width is %dpx", viewportWidthNew));
            return viewportWidthNew;
        }
        return viewportWidth;
    }

    public static <T extends PageObject> Class<T> getBestMatchingClass(Class<T> baseClass, WebDriver driver, String prefix) {
        PrioritizedClassInfos prioritizedClassInfos = Caches.getCache(baseClass, prefix);
        if (prioritizedClassInfos == null) {
            ResponsiveClassFinder.findSubPagesOf(baseClass, prefix);
            prioritizedClassInfos = Caches.getCache(baseClass, prefix);
            if (prioritizedClassInfos == null) {
                throw new SystemException("Something went wrong scanning this class for sub types: " + baseClass.getName());
            }
        }
        prioritizedClassInfos.logContent();
        List prefixedClasses = prioritizedClassInfos.getPrefixedClasses();
        List nonPrexidClasses = prioritizedClassInfos.getNonPrefixedClasses();
        int viewPortWidth = -1;
        Class bestMatchingClass = null;
        for (ResolutionClassInfo c : prefixedClasses) {
            if (!c.hasResolution() || !c.matchesResolution(viewPortWidth = ResponsiveClassFinder.getBrowserViewportSize(driver, viewPortWidth))) continue;
            bestMatchingClass = c.implClass;
        }
        if (bestMatchingClass == null && prioritizedClassInfos.prefixedBaseClass != null) {
            bestMatchingClass = prioritizedClassInfos.prefixedBaseClass;
        }
        if (bestMatchingClass == null) {
            for (ResolutionClassInfo c : nonPrexidClasses) {
                if (c.hasResolution()) {
                    viewPortWidth = ResponsiveClassFinder.getBrowserViewportSize(driver, viewPortWidth);
                }
                if (!c.matchesResolution(viewPortWidth)) continue;
                bestMatchingClass = c.implClass;
            }
        }
        if (bestMatchingClass == null && prioritizedClassInfos.baseClass != null) {
            bestMatchingClass = prioritizedClassInfos.baseClass;
        }
        if (bestMatchingClass == null) {
            throw new RuntimeException("Could not find a matching page class implementation for " + baseClass.getSimpleName() + "\nMaybe you can solve this by making the base class non-abstract.");
        }
        if (viewPortWidth > 0) {
            LOGGER.debug("For " + viewPortWidth + "px view port width, I'm choosing: " + bestMatchingClass.getSimpleName());
        } else {
            LOGGER.debug("Without any viewport check, I'm choosing: " + bestMatchingClass.getSimpleName());
        }
        return bestMatchingClass;
    }

    public static void clearCache() {
        Caches.IMPLEMENTATIONS_CACHE.clear();
    }

    private static class ResolutionClassInfo<T extends PageObject> {
        int resLowerLimit = -1;
        int resUpperLimit = -1;
        Class<T> implClass;

        public ResolutionClassInfo(Class<T> implClass, String resPart) {
            this.implClass = implClass;
            this.grabResolutions(resPart);
        }

        private void grabResolutions(String resPart) {
            if (StringUtils.isBlank((CharSequence)resPart)) {
                return;
            }
            String[] split = resPart.split(ResponsiveClassFinder.SCHEMA_DIV);
            String leftValue = split[1];
            String rightValue = split[2];
            if (ResponsiveClassFinder.KEYWORD_RES.equals(leftValue)) {
                throw new NotYetImplementedException();
            }
            if (!ResponsiveClassFinder.KEYWORD_MIN.equals(leftValue)) {
                this.resLowerLimit = Integer.valueOf(leftValue.replace(ResponsiveClassFinder.KEYWORD_PIXEL, ""));
            }
            if (!ResponsiveClassFinder.KEYWORD_MAX.equals(rightValue)) {
                this.resUpperLimit = Integer.valueOf(rightValue.replace(ResponsiveClassFinder.KEYWORD_PIXEL, ""));
            }
        }

        public boolean hasResolution() {
            return this.resLowerLimit >= 0 || this.resUpperLimit >= 0;
        }

        public boolean matchesResolution(int resolution) {
            if (resolution < 1) {
                return true;
            }
            if (this.resLowerLimit < 0 && this.resUpperLimit < 0) {
                return true;
            }
            boolean lowMatches = false;
            boolean highMatches = false;
            if (resolution >= this.resLowerLimit) {
                lowMatches = true;
            }
            if (this.resUpperLimit < 0 || resolution <= this.resUpperLimit) {
                highMatches = true;
            }
            return lowMatches && highMatches;
        }

        public String toString() {
            return this.implClass.getSimpleName();
        }
    }

    private static class PrioritizedClassInfos<T extends PageObject> {
        List<ResolutionClassInfo<T>> prefixedClasses = new LinkedList<ResolutionClassInfo<T>>();
        Class<T> prefixedBaseClass;
        List<ResolutionClassInfo<T>> nonPrefixedClasses = new LinkedList<ResolutionClassInfo<T>>();
        Class<T> baseClass;

        private PrioritizedClassInfos() {
        }

        public List<ResolutionClassInfo<T>> getPrefixedClasses() {
            return this.prefixedClasses;
        }

        public List<ResolutionClassInfo<T>> getNonPrefixedClasses() {
            return this.nonPrefixedClasses;
        }

        public void setBaseClass(Class<T> baseClass) {
            this.baseClass = baseClass;
        }

        public void setPrefixedBaseClass(Class<T> prefixedBaseClass) {
            this.prefixedBaseClass = prefixedBaseClass;
        }

        public void logContent() {
            Object msg = "";
            if (this.prefixedClasses.size() > 0) {
                msg = (String)msg + "Prefixed Res Impls:\n";
                for (ResolutionClassInfo<T> c : this.prefixedClasses) {
                    msg = (String)msg + "  " + c + "\n";
                }
            }
            if (this.prefixedBaseClass != null) {
                msg = (String)msg + "Prefixed Base:\n";
                msg = (String)msg + "  " + this.prefixedBaseClass.getSimpleName() + "\n";
            }
            if (this.nonPrefixedClasses.size() > 0) {
                msg = (String)msg + "Res Impls:\n";
                for (ResolutionClassInfo<T> c : this.nonPrefixedClasses) {
                    msg = (String)msg + "  " + c + "\n";
                }
            }
            if (this.baseClass != null) {
                msg = (String)msg + "Base:\n";
                msg = (String)msg + "  " + this.baseClass.getSimpleName() + "\n";
            }
            if ("".equals(msg)) {
                msg = (String)msg + "No usable (non-abstract) implementations found.";
            }
            LOGGER.debug((String)msg);
        }
    }

    private static class Caches {
        private static final String NULL_PAGE_PREFIX = " _ ";
        private static final Map<Class<? extends PageObject>, Map<String, PrioritizedClassInfos<? extends PageObject>>> IMPLEMENTATIONS_CACHE = new ConcurrentHashMap<Class<? extends PageObject>, Map<String, PrioritizedClassInfos<? extends PageObject>>>();

        private Caches() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static PrioritizedClassInfos getCache(Class<? extends PageObject> pageClass, String prefixOrNull) {
            if (StringUtils.isBlank((CharSequence)prefixOrNull)) {
                prefixOrNull = NULL_PAGE_PREFIX;
            }
            Map<Class<? extends PageObject>, Map<String, PrioritizedClassInfos<? extends PageObject>>> map = IMPLEMENTATIONS_CACHE;
            synchronized (map) {
                if (!IMPLEMENTATIONS_CACHE.containsKey(pageClass)) {
                    return null;
                }
                Map<String, PrioritizedClassInfos<? extends PageObject>> map2 = IMPLEMENTATIONS_CACHE.get(pageClass);
                if (!map2.containsKey(prefixOrNull)) {
                    return null;
                }
                return map2.get(prefixOrNull);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void setCache(Class<? extends PageObject> pageClass, String prefixOrNull, PrioritizedClassInfos<? extends PageObject> prioritizedClassInfos) {
            if (StringUtils.isBlank((CharSequence)prefixOrNull)) {
                prefixOrNull = NULL_PAGE_PREFIX;
            }
            Map<Class<? extends PageObject>, Map<String, PrioritizedClassInfos<? extends PageObject>>> map = IMPLEMENTATIONS_CACHE;
            synchronized (map) {
                if (!IMPLEMENTATIONS_CACHE.containsKey(pageClass)) {
                    IMPLEMENTATIONS_CACHE.put(pageClass, new HashMap());
                }
                Map<String, PrioritizedClassInfos<? extends PageObject>> map2 = IMPLEMENTATIONS_CACHE.get(pageClass);
                map2.put(prefixOrNull, prioritizedClassInfos);
            }
        }
    }
}

