/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.internal.action;

import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.pageobjects.Check;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.AbstractPage;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.action.AbstractFieldAction;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.core.UiElementBase;
import java.lang.reflect.Field;

public abstract class AbstractCheckFieldAction
extends AbstractFieldAction
implements Loggable {
    private UiElementBase checkableInstance;
    protected boolean execute = false;

    public AbstractCheckFieldAction(Field field, AbstractPage declaringPage) {
        super(field, declaringPage);
    }

    protected abstract void checkField(UiElementBase var1, Check var2);

    @Override
    public boolean before() {
        boolean isCheckAnnotated = this.field.isAnnotationPresent(Check.class);
        boolean isCheckable = UiElementBase.class.isAssignableFrom(this.field.getType());
        if (isCheckAnnotated && !isCheckable) {
            throw new RuntimeException("Field {" + this.field.getName() + "} of " + this.declaringPage + " is annotated with @Check, but the class doesn't implement " + UiElementBase.class.getCanonicalName());
        }
        if (isCheckable) {
            if ((this.field.getModifiers() & 8) == 8) {
                throw new RuntimeException("Checkable field MUST be non-static: " + this.declaringPage + "." + this.field.getName());
            }
            if (isCheckAnnotated) {
                this.execute = true;
            }
        }
        this.additionalBeforeCheck();
        return this.execute;
    }

    protected void additionalBeforeCheck() {
    }

    @Override
    public void execute() {
        String fieldName = this.field.getName();
        try {
            this.checkableInstance = (UiElementBase)this.field.get(this.declaringPage);
        }
        catch (IllegalAccessException e) {
            this.log().error("Internal Error", (Throwable)e);
            return;
        }
        catch (IllegalArgumentException e) {
            this.log().error("Internal Error. Maybe tried to get field from object that does not declare it.", (Throwable)e);
            return;
        }
        Check check = this.field.getAnnotation(Check.class);
        if (this.checkableInstance == null) {
            throw new RuntimeException(String.format("Field {%s.%s} is annotated with @Check and was never initialized (it is null).This is not allowed because @Check indicates a mandatory GuiElement of a Page.", this.declaringPage, fieldName));
        }
        this.checkField(this.checkableInstance, check);
    }

    @Override
    public void after() {
    }
}

