/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.internal.action;

import eu.tsystems.mms.tic.testframework.annotations.PageOptions;
import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.enums.CheckRule;
import eu.tsystems.mms.tic.testframework.execution.testng.Assertion;
import eu.tsystems.mms.tic.testframework.execution.testng.CollectedAssertion;
import eu.tsystems.mms.tic.testframework.execution.testng.OptionalAssertion;
import eu.tsystems.mms.tic.testframework.pageobjects.Check;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.AbstractPage;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.action.AbstractCheckFieldAction;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.core.UiElementBase;
import eu.tsystems.mms.tic.testframework.testing.TestController;
import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;

public class GuiElementCheckFieldAction
extends AbstractCheckFieldAction {
    private static final TestController.Overrides overrides = (TestController.Overrides)Testerra.getInjector().getInstance(TestController.Overrides.class);
    private final CheckRule defaultCheckRule;

    public GuiElementCheckFieldAction(Field field, CheckRule defaultCheckRule, AbstractPage declaringPage) {
        super(field, declaringPage);
        this.defaultCheckRule = defaultCheckRule;
    }

    private void pCheckField(UiElementBase guiElement, Check check) {
        int useTimeout;
        CheckRule checkRule = check.checkRule();
        if (checkRule == CheckRule.DEFAULT && (checkRule = this.defaultCheckRule) == CheckRule.DEFAULT) {
            checkRule = CheckRule.valueOf((String)UiElement.Properties.CHECK_RULE.asString());
        }
        if (overrides.hasTimeout()) {
            useTimeout = overrides.getTimeoutInSeconds();
        } else {
            useTimeout = check.timeout();
            if (useTimeout < 0 && this.declaringPage.getClass().isAnnotationPresent(PageOptions.class)) {
                PageOptions annotation = this.declaringPage.getClass().getAnnotation(PageOptions.class);
                useTimeout = annotation.elementTimeoutInSeconds();
            }
        }
        int prevTimeout = -1;
        if (useTimeout >= 0) {
            prevTimeout = overrides.setTimeout(useTimeout);
        }
        if (check.collect() && check.optional()) {
            this.log().warn("{} -> {}: @Check 'collect' and 'optional' are used but 'collect' will be ignored.", (Object)this.declaringPage.getName(false), (Object)this.field.getName());
        }
        Assertion previousAssertionImpl = null;
        if (check.optional()) {
            OptionalAssertion assertionImpl = (OptionalAssertion)Testerra.getInjector().getInstance(OptionalAssertion.class);
            previousAssertionImpl = overrides.setAssertionImpl((Assertion)assertionImpl);
        } else if (check.collect()) {
            CollectedAssertion assertionImpl = (CollectedAssertion)Testerra.getInjector().getInstance(CollectedAssertion.class);
            previousAssertionImpl = overrides.setAssertionImpl((Assertion)assertionImpl);
        }
        switch (checkRule) {
            case IS_PRESENT: {
                guiElement.expect().present(true);
                break;
            }
            case IS_NOT_PRESENT: {
                guiElement.expect().present(false);
                break;
            }
            case IS_NOT_DISPLAYED: {
                if (!guiElement.waitFor().present(true)) break;
                guiElement.expect().displayed(false);
                break;
            }
            default: {
                guiElement.expect().displayed(true);
            }
        }
        if (prevTimeout >= 0) {
            overrides.setTimeout(prevTimeout);
        }
        if (check.optional() || check.collect()) {
            overrides.setAssertionImpl(previousAssertionImpl);
        }
    }

    @Override
    protected void checkField(UiElementBase checkableInstance, Check check) {
        try {
            this.pCheckField(checkableInstance, check);
        }
        catch (AssertionError error) {
            String prioritizedErrorMessage = check.prioritizedErrorMessage();
            if (StringUtils.isNotBlank((CharSequence)prioritizedErrorMessage)) {
                throw new AssertionError(prioritizedErrorMessage, (Throwable)((Object)error));
            }
            throw error;
        }
    }
}

