/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts;

import eu.tsystems.mms.tic.testframework.internal.asserts.AbstractPropertyAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.AssertionProvider;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultFileAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultQuantityAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.FileAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.ImageAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.QuantityAssertion;
import eu.tsystems.mms.tic.testframework.layout.LayoutCheck;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultImageAssertion
extends AbstractPropertyAssertion<File>
implements ImageAssertion {
    public DefaultImageAssertion(AbstractPropertyAssertion parentAssertion, AssertionProvider<File> provider) {
        super(parentAssertion, provider);
    }

    public QuantityAssertion<Double> pixelDistance(final String referenceImageName) {
        final AtomicReference atomicMatchStep = new AtomicReference();
        return (QuantityAssertion)propertyAssertionFactory.createWithParent(DefaultQuantityAssertion.class, (AbstractPropertyAssertion)this, (AssertionProvider)new AssertionProvider<Double>(){

            public Double getActual() {
                LayoutCheck.MatchStep matchStep = LayoutCheck.matchPixels((File)DefaultImageAssertion.this.provider.getActual(), referenceImageName);
                atomicMatchStep.set(matchStep);
                return matchStep.distance;
            }

            public String createSubject() {
                return "pixel distance to image=" + AssertionProvider.Format.param((Object)referenceImageName);
            }

            public void failedFinally(AbstractPropertyAssertion assertion) {
                LayoutCheck.MatchStep matchStep = (LayoutCheck.MatchStep)atomicMatchStep.get();
                atomicMatchStep.get();
                if (matchStep != null && !matchStep.takeReferenceOnly) {
                    LayoutCheck.toReport(matchStep);
                }
            }
        });
    }

    public FileAssertion file() {
        return (FileAssertion)propertyAssertionFactory.createWithParent(DefaultFileAssertion.class, (AbstractPropertyAssertion)this, (AssertionProvider)new AssertionProvider<File>(){

            public File getActual() {
                return (File)DefaultImageAssertion.this.provider.getActual();
            }

            public String createSubject() {
                return ((File)DefaultImageAssertion.this.provider.getActual()).getAbsolutePath();
            }
        });
    }
}

