/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts;

import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.exceptions.ElementNotFoundException;
import eu.tsystems.mms.tic.testframework.exceptions.UiElementAssertionError;
import eu.tsystems.mms.tic.testframework.execution.testng.Assertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.AbstractPropertyAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.AssertionProvider;
import eu.tsystems.mms.tic.testframework.internal.asserts.BinaryAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultBinaryAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultQuantityAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.DefaultStringAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.ImageAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.PropertyAssertionConfig;
import eu.tsystems.mms.tic.testframework.internal.asserts.PropertyAssertionFactory;
import eu.tsystems.mms.tic.testframework.internal.asserts.QuantityAssertion;
import eu.tsystems.mms.tic.testframework.internal.asserts.StringAssertion;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.pageobjects.GuiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.DefaultImageAssertion;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.DefaultRectAssertion;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.RectAssertion;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.asserts.UiElementAssertion;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.core.GuiElementCore;
import eu.tsystems.mms.tic.testframework.report.Report;
import eu.tsystems.mms.tic.testframework.report.model.context.Screenshot;
import eu.tsystems.mms.tic.testframework.report.utils.ExecutionContextController;
import java.awt.Color;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.openqa.selenium.Rectangle;

public class DefaultUiElementAssertion
implements UiElementAssertion {
    private static final PropertyAssertionFactory propertyAssertionFactory = (PropertyAssertionFactory)Testerra.getInjector().getInstance(PropertyAssertionFactory.class);
    private static final Report report = (Report)Testerra.getInjector().getInstance(Report.class);
    private static final boolean demoModeEnabled = Testerra.Properties.DEMO_MODE.asBool();
    private final PropertyAssertionConfig propertyAssertionConfig;
    private final GuiElementCore core;
    private final GuiElement guiElement;

    public DefaultUiElementAssertion(UiElement uiElement, PropertyAssertionConfig config) {
        this.guiElement = (GuiElement)uiElement;
        this.core = this.guiElement.getCore();
        this.propertyAssertionConfig = config;
    }

    public DefaultUiElementAssertion(UiElement uiElement, Assertion useAssertion) {
        this.guiElement = (GuiElement)uiElement;
        this.core = this.guiElement.getCore();
        this.propertyAssertionConfig = new PropertyAssertionConfig();
        this.propertyAssertionConfig.throwErrors = true;
        this.propertyAssertionConfig.useAssertion = useAssertion;
    }

    @Override
    public StringAssertion<String> tagName() {
        return (StringAssertion)propertyAssertionFactory.createWithConfig(DefaultStringAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new UiElementAssertionProvider<String>(){

            public String getActual() {
                return DefaultUiElementAssertion.this.core.getTagName();
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultUiElementAssertion.this.guiElement.toString(), "tagName=" + AssertionProvider.Format.param(this.getSafeActual())});
            }
        });
    }

    @Override
    public StringAssertion<String> text() {
        return (StringAssertion)propertyAssertionFactory.createWithConfig(DefaultStringAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new UiElementAssertionProvider<String>(){

            public String getActual() {
                return DefaultUiElementAssertion.this.core.getText();
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultUiElementAssertion.this.guiElement.toString(), "text=" + AssertionProvider.Format.shortString(this.getSafeActual())});
            }
        });
    }

    @Override
    public StringAssertion<String> attribute(final String attribute) {
        return (StringAssertion)propertyAssertionFactory.createWithConfig(DefaultStringAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new UiElementAssertionProvider<String>(){

            public String getActual() {
                return DefaultUiElementAssertion.this.core.getAttribute(attribute);
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultUiElementAssertion.this.guiElement.toString(), attribute + "=" + AssertionProvider.Format.param(this.getSafeActual())});
            }
        });
    }

    @Override
    public StringAssertion<String> css(final String property) {
        return (StringAssertion)propertyAssertionFactory.createWithConfig(DefaultStringAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new UiElementAssertionProvider<String>(){

            public String getActual() {
                return DefaultUiElementAssertion.this.core.getCssValue(property);
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultUiElementAssertion.this.guiElement.toString(), "css { " + AssertionProvider.Format.label((String)property, this.getSafeActual()) + " }"});
            }
        });
    }

    @Override
    public BinaryAssertion<Boolean> present() {
        return (BinaryAssertion)propertyAssertionFactory.createWithConfig(DefaultBinaryAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new UiElementAssertionProvider<Boolean>(){

            public Boolean getActual() {
                return DefaultUiElementAssertion.this.core.isPresent();
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultUiElementAssertion.this.guiElement.toString(), "present"});
            }
        });
    }

    @Override
    public BinaryAssertion<Boolean> visible(final boolean fullyVisible) {
        return (BinaryAssertion)propertyAssertionFactory.createWithConfig(DefaultBinaryAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new UiElementAssertionProvider<Boolean>(){

            public Boolean getActual() {
                return DefaultUiElementAssertion.this.core.isVisible(fullyVisible);
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultUiElementAssertion.this.guiElement.toString(), (fullyVisible ? "complete " : "") + "visible"});
            }
        });
    }

    @Override
    public BinaryAssertion<Boolean> visiblePartial() {
        return this.visible(false);
    }

    @Override
    public BinaryAssertion<Boolean> visibleFull() {
        return this.visible(true);
    }

    @Override
    public BinaryAssertion<Boolean> displayed() {
        return (BinaryAssertion)propertyAssertionFactory.createWithConfig(DefaultBinaryAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new UiElementAssertionProvider<Boolean>(){

            public Boolean getActual() {
                try {
                    return DefaultUiElementAssertion.this.core.isDisplayed();
                }
                catch (ElementNotFoundException e) {
                    return false;
                }
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultUiElementAssertion.this.guiElement.toString(), "displayed"});
            }
        });
    }

    @Override
    public BinaryAssertion<Boolean> enabled() {
        return (BinaryAssertion)propertyAssertionFactory.createWithConfig(DefaultBinaryAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new UiElementAssertionProvider<Boolean>(){

            public Boolean getActual() {
                return DefaultUiElementAssertion.this.core.isEnabled();
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultUiElementAssertion.this.guiElement.toString(), "enabled"});
            }
        });
    }

    @Override
    public BinaryAssertion<Boolean> selected() {
        return (BinaryAssertion)propertyAssertionFactory.createWithConfig(DefaultBinaryAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new UiElementAssertionProvider<Boolean>(){

            public Boolean getActual() {
                return DefaultUiElementAssertion.this.core.isSelected();
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultUiElementAssertion.this.guiElement.toString(), "selected"});
            }
        });
    }

    @Override
    public BinaryAssertion<Boolean> selectable() {
        return (BinaryAssertion)propertyAssertionFactory.createWithConfig(DefaultBinaryAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new UiElementAssertionProvider<Boolean>(){

            public Boolean getActual() {
                return DefaultUiElementAssertion.this.core.isSelectable();
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultUiElementAssertion.this.guiElement.toString(), "selectable"});
            }
        });
    }

    @Override
    public RectAssertion bounds() {
        return (RectAssertion)propertyAssertionFactory.createWithConfig(DefaultRectAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new UiElementAssertionProvider<Rectangle>(){

            public Rectangle getActual() {
                return DefaultUiElementAssertion.this.core.getRect();
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultUiElementAssertion.this.guiElement.toString(), "bounds"});
            }
        });
    }

    @Override
    public QuantityAssertion<Integer> foundElements() {
        return (QuantityAssertion)propertyAssertionFactory.createWithConfig(DefaultQuantityAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new UiElementAssertionProvider<Integer>(){

            public Integer getActual() {
                try {
                    return DefaultUiElementAssertion.this.core.getNumberOfFoundElements();
                }
                catch (ElementNotFoundException e) {
                    return 0;
                }
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultUiElementAssertion.this.guiElement.toString(), "numberOfElements"});
            }
        });
    }

    private static void addScreenshotToReport(Screenshot screenshot) {
        report.addScreenshot(screenshot, Report.FileMode.COPY);
        ExecutionContextController.getCurrentMethodContext().addScreenshot(screenshot);
    }

    public ImageAssertion screenshot(Report.Mode reportMode) {
        Screenshot screenshot = new Screenshot(this.guiElement.getName(true));
        screenshot.setFile(this.core.takeScreenshot());
        final AtomicReference<Screenshot> atomicScreenshot = new AtomicReference<Screenshot>();
        atomicScreenshot.set(screenshot);
        if (reportMode == Report.Mode.ALWAYS) {
            DefaultUiElementAssertion.addScreenshotToReport((Screenshot)atomicScreenshot.get());
        }
        return (ImageAssertion)propertyAssertionFactory.createWithConfig(DefaultImageAssertion.class, this.propertyAssertionConfig, (AssertionProvider)new UiElementAssertionProvider<File>(){

            public File getActual() {
                return ((Screenshot)atomicScreenshot.get()).getScreenshotFile();
            }

            @Override
            public void failed(AbstractPropertyAssertion assertion) {
                ((Screenshot)atomicScreenshot.get()).setFile(DefaultUiElementAssertion.this.core.takeScreenshot());
            }

            public void failedFinally(AbstractPropertyAssertion assertion) {
                DefaultUiElementAssertion.addScreenshotToReport((Screenshot)atomicScreenshot.get());
            }

            public String createSubject() {
                return AssertionProvider.Format.separate((Object[])new Object[]{DefaultUiElementAssertion.this.guiElement.toString(), "screenshot"});
            }
        });
    }

    abstract class UiElementAssertionProvider<T>
    extends AssertionProvider<T>
    implements Loggable {
        UiElementAssertionProvider() {
        }

        public AssertionError wrapAssertionError(AssertionError assertionError) {
            return new UiElementAssertionError(DefaultUiElementAssertion.this.guiElement.getData(), (Throwable)((Object)assertionError));
        }

        public void passed(AbstractPropertyAssertion<T> assertion) {
            if (demoModeEnabled) {
                try {
                    DefaultUiElementAssertion.this.guiElement.getCore().highlight(new Color(0, 255, 0));
                }
                catch (Throwable e) {
                    this.log().warn("Unable to highlight a PASSED assertion: " + e.getMessage());
                }
            }
        }

        public void failed(AbstractPropertyAssertion<T> assertion) {
            if (demoModeEnabled) {
                try {
                    DefaultUiElementAssertion.this.guiElement.getCore().highlight(new Color(255, 0, 0));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public T getSafeActual() {
            try {
                return (T)this.getActual();
            }
            catch (ElementNotFoundException e) {
                return null;
            }
        }
    }
}

