/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.internal.core;

import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.constants.JSMouseAction;
import eu.tsystems.mms.tic.testframework.exceptions.ElementNotFoundException;
import eu.tsystems.mms.tic.testframework.exceptions.UiElementException;
import eu.tsystems.mms.tic.testframework.execution.testng.Assertion;
import eu.tsystems.mms.tic.testframework.execution.testng.InstantAssertion;
import eu.tsystems.mms.tic.testframework.internal.Timings;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.DefaultLocator;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.core.AbstractGuiElementCore;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.core.GuiElementData;
import eu.tsystems.mms.tic.testframework.utils.JSUtils;
import eu.tsystems.mms.tic.testframework.utils.WebDriverUtils;
import eu.tsystems.mms.tic.testframework.webdrivermanager.IWebDriverManager;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.events.EventFiringWebDriver;

public abstract class AbstractWebDriverCore
extends AbstractGuiElementCore
implements Loggable {
    private static final Assertion assertion = (Assertion)Testerra.getInjector().getInstance(InstantAssertion.class);

    public AbstractWebDriverCore(GuiElementData guiElementData) {
        super(guiElementData);
    }

    private By correctToRelativeXPath(GuiElementData parentData, By by) {
        String abstractLocatorString = by.toString();
        if (abstractLocatorString.toLowerCase().contains("xpath")) {
            int i = abstractLocatorString.indexOf(":") + 1;
            Object xpath = abstractLocatorString.substring(i).trim();
            boolean corrected = false;
            if (((String)xpath).startsWith("/")) {
                xpath = ((String)xpath).replaceFirst("/", "./");
                corrected = true;
            } else if (!((String)xpath).startsWith("(") && !((String)xpath).startsWith(".")) {
                xpath = "./" + (String)xpath;
                corrected = true;
            }
            if (parentData.isShadowRoot()) {
                xpath = "./." + (String)xpath;
                corrected = true;
            }
            if (corrected) {
                by = By.xpath((String)xpath);
            }
        } else if (parentData.isShadowRoot()) {
            throw new UiElementException(this.guiElementData.getGuiElement(), "Finding sub elements on shadowRoot() only supports " + By.ByXPath.class.getSimpleName());
        }
        return by;
    }

    private void throwNotFoundException(Throwable reason) {
        throw new ElementNotFoundException((UiElement)this.guiElementData.getGuiElement(), reason);
    }

    private List<WebElement> findElementsFromWebDriver(WebDriver webDriver, By by) {
        if (webDriver instanceof EventFiringWebDriver) {
            webDriver = ((EventFiringWebDriver)webDriver).getWrappedDriver();
        }
        try {
            return webDriver.findElements(by);
        }
        catch (Throwable throwable) {
            this.throwNotFoundException(throwable);
            return null;
        }
    }

    private List<WebElement> findElementsFromWebElement(WebElement webElement, By by) {
        try {
            return webElement.findElements(by);
        }
        catch (Throwable throwable) {
            this.throwNotFoundException(throwable);
            return null;
        }
    }

    private void findWebElements(Consumer<List<WebElement>> consumer) {
        WebDriver webDriver = this.guiElementData.getWebDriver();
        DefaultLocator locate = this.guiElementData.getLocate();
        By by = locate.getBy();
        GuiElementData parentData = this.guiElementData.getParent();
        if (parentData != null) {
            parentData.getGuiElement().getCore().findWebElement(parentWebElement -> {
                if (parentData.isFrame()) {
                    this.switchToFrame(webDriver, (WebElement)parentWebElement);
                    consumer.accept(this.findElementsFromWebDriver(webDriver, by));
                } else {
                    consumer.accept(this.findElementsFromWebElement((WebElement)parentWebElement, this.correctToRelativeXPath(parentData, by)));
                }
            });
        } else {
            this.switchToDefaultContent(webDriver);
            consumer.accept(this.findElementsFromWebDriver(webDriver, by));
        }
    }

    protected abstract void switchToDefaultContent(WebDriver var1);

    protected abstract void switchToFrame(WebDriver var1, WebElement var2);

    private void filterWebElements(List<WebElement> webElements) {
        Predicate<WebElement> filter = this.guiElementData.getLocate().getFilter();
        if (filter != null) {
            webElements.removeIf(webElement -> !filter.test((WebElement)webElement));
        }
    }

    @Override
    public void findWebElement(Consumer<WebElement> consumer) {
        long start = System.currentTimeMillis();
        Timings.raiseFindCounter();
        this.findWebElements(webElements -> {
            int numElementsBeforeFilter = webElements.size();
            this.filterWebElements((List<WebElement>)webElements);
            DefaultLocator locate = this.guiElementData.getLocate();
            if (locate.isUnique() && webElements.size() > 1) {
                this.throwNotFoundException((Throwable)((Object)new AssertionError((Object)assertion.formatExpectEquals((Object)webElements.size(), (Object)1, (Object)this.formatLocateSubject(locate, numElementsBeforeFilter)))));
            }
            if (webElements.size() > 0) {
                WebElement webElement = (WebElement)webElements.get(Math.max(0, this.guiElementData.getIndex()));
                WebDriver webDriver = this.guiElementData.getWebDriver();
                if (this.guiElementData.isShadowRoot()) {
                    try {
                        Object shadowedWebElement = JSUtils.executeScriptWOCatch(webDriver, "return arguments[0].shadowRoot.firstChild", webElement);
                        if (shadowedWebElement instanceof WebElement) {
                            webElement = (WebElement)shadowedWebElement;
                        }
                    }
                    catch (Exception e) {
                        this.log().error("Could not detect shadow root for " + this.guiElementData.toString() + ": " + e.getMessage());
                    }
                } else if ("frame".equals(webElement.getTagName()) || "iframe".equals(webElement.getTagName())) {
                    this.guiElementData.setIsFrame(true);
                }
                this.logTimings(start, Timings.getFindCounter());
                consumer.accept(webElement);
                if (this.guiElementData.isFrame()) {
                    this.switchToDefaultContent(webDriver);
                }
            } else {
                this.throwNotFoundException((Throwable)((Object)new AssertionError((Object)assertion.formatExpectGreaterEqualThan(assertion.toBigDecimal((Object)0), assertion.toBigDecimal((Object)1), (Object)this.formatLocateSubject(locate, numElementsBeforeFilter)))));
            }
        });
    }

    private String formatLocateSubject(DefaultLocator locator, int numElementsBeforeFilter) {
        if (locator.getFilter() != null) {
            return "found elements";
        }
        return String.format("total elements [%d] filtered", numElementsBeforeFilter);
    }

    private void logTimings(long start, int findCounter) {
        if (findCounter != -1) {
            GuiElementData parent = this.guiElementData.getParent();
            long end = System.currentTimeMillis();
            long ms = end - start;
            if (parent != null) {
                Timings.TIMING_GUIELEMENT_FIND_WITH_PARENT.put(findCounter, ms);
            } else {
                Timings.TIMING_GUIELEMENT_FIND.put(findCounter, ms);
            }
            long limit = 2000L;
            if (ms >= 2000L) {
                this.log().warn(String.format("find() #%d of %s took %.2fs of %.0fs", findCounter, this, Float.valueOf((float)ms / 1000.0f), Float.valueOf(2.0f)));
            }
        }
    }

    @Override
    public void scrollToElement(int yOffset) {
        this.pScrollToElement(yOffset);
    }

    @Override
    public void scrollIntoView(Point offset) {
        this.findWebElement(webElement -> {
            JSUtils utils = new JSUtils();
            utils.scrollToCenter(this.guiElementData.getWebDriver(), (WebElement)webElement, offset);
        });
    }

    @Override
    public void scrollToTop() {
        this.findWebElement(webElement -> {
            JSUtils utils = new JSUtils();
            utils.scrollElementToTop(this.guiElementData.getWebDriver(), (WebElement)webElement);
        });
    }

    private void pScrollToElement(int yOffset) {
        this.findWebElement(webElement -> {
            Point location = webElement.getLocation();
            int x = location.getX();
            int y = location.getY() - yOffset;
            this.log().trace("Scrolling into view: " + x + ", " + y);
            JSUtils.executeScript(this.guiElementData.getWebDriver(), "scroll(" + x + ", " + y + ");", new Object[0]);
        });
    }

    @Override
    public void select() {
        if (!this.isSelected()) {
            this.click();
        }
    }

    @Override
    public void deselect() {
        if (this.isSelected()) {
            this.click();
        }
    }

    @Override
    public void type(String text) {
        this.pType(text);
    }

    private void pType(String text) {
        if (text == null) {
            this.log().warn("Text to type is null. Typing nothing.");
            return;
        }
        if (text.isEmpty()) {
            this.log().warn("Text to type is empty!");
        }
        this.findWebElement(webElement -> {
            webElement.clear();
            webElement.sendKeys(new CharSequence[]{text});
            String valueProperty = webElement.getAttribute("value");
            if (valueProperty != null) {
                if (!valueProperty.equals(text)) {
                    this.log().warn("Writing text to input field didn't work. Trying again.");
                    webElement.clear();
                    webElement.sendKeys(new CharSequence[]{text});
                    if (!webElement.getAttribute("value").equals(text)) {
                        this.log().error("Writing text to input field didn't work on second try!");
                    }
                }
            } else {
                this.log().warn("Cannot perform value check after type() because " + this.toString() + " doesn't have a value property. Consider using sendKeys() instead.");
            }
        });
    }

    @Override
    public void click() {
        this.findWebElement(webElement -> webElement.click());
    }

    @Override
    public void submit() {
        this.findWebElement(WebElement::submit);
    }

    @Override
    public void sendKeys(CharSequence ... charSequences) {
        this.findWebElement(webElement -> webElement.sendKeys(charSequences));
    }

    @Override
    public void clear() {
        this.findWebElement(WebElement::clear);
    }

    @Override
    public String getTagName() {
        AtomicReference atomicReference = new AtomicReference();
        this.findWebElement(webElement -> atomicReference.set(webElement.getTagName()));
        return (String)atomicReference.get();
    }

    @Override
    public String getAttribute(String attributeName) {
        AtomicReference atomicReference = new AtomicReference();
        this.findWebElement(webElement -> atomicReference.set(webElement.getAttribute(attributeName)));
        return (String)atomicReference.get();
    }

    @Override
    public boolean isSelected() {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.findWebElement(webElement -> atomicBoolean.set(webElement.isSelected()));
        return atomicBoolean.get();
    }

    @Override
    public boolean isEnabled() {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.findWebElement(webElement -> atomicBoolean.set(webElement.isEnabled()));
        return atomicBoolean.get();
    }

    @Override
    public String getText() {
        AtomicReference atomicReference = new AtomicReference();
        this.findWebElement(webElement -> atomicReference.set(webElement.getText()));
        return (String)atomicReference.get();
    }

    @Override
    public boolean isDisplayed() {
        if (this.guiElementData.isShadowRoot()) {
            return false;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.findWebElement(webElement -> atomicBoolean.set(webElement.isDisplayed()));
        return atomicBoolean.get();
    }

    @Override
    public Rectangle getRect() {
        AtomicReference atomicReference = new AtomicReference();
        this.findWebElement(webElement -> atomicReference.set(webElement.getRect()));
        return (Rectangle)atomicReference.get();
    }

    @Override
    public boolean isVisible(boolean fullyVisible) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.findWebElement(webElement -> {
            if (!webElement.isDisplayed()) {
                return;
            }
            Rectangle viewport = WebDriverUtils.getViewport(this.guiElementData.getWebDriver());
            Point elementLocation = webElement.getLocation();
            Dimension elementSize = webElement.getSize();
            java.awt.Rectangle viewportRect = new java.awt.Rectangle(viewport.x, viewport.y, viewport.width, viewport.height);
            java.awt.Rectangle elementRect = new java.awt.Rectangle(elementLocation.x, elementLocation.y, elementSize.width, elementSize.height);
            atomicBoolean.set(fullyVisible && viewportRect.contains(elementRect) || viewportRect.intersects(elementRect));
        });
        return atomicBoolean.get();
    }

    @Override
    public boolean isSelectable() {
        return this.pIsSelectable();
    }

    private boolean pIsSelectable() {
        boolean selectionStatusChanged;
        boolean wasSelected;
        try {
            wasSelected = this.isSelected();
        }
        catch (WebDriverException e) {
            if (e.getMessage().toLowerCase().contains("unable to determine if element is selected")) {
                return false;
            }
            throw e;
        }
        this.click();
        boolean isSelected = this.isSelected();
        boolean bl = selectionStatusChanged = wasSelected != isSelected;
        if (selectionStatusChanged) {
            this.click();
        }
        return selectionStatusChanged;
    }

    @Override
    public Point getLocation() {
        AtomicReference atomicReference = new AtomicReference();
        this.findWebElement(webElement -> atomicReference.set(webElement.getLocation()));
        return (Point)atomicReference.get();
    }

    @Override
    public Dimension getSize() {
        AtomicReference atomicReference = new AtomicReference();
        this.findWebElement(webElement -> atomicReference.set(webElement.getSize()));
        return (Dimension)atomicReference.get();
    }

    @Override
    public String getCssValue(String cssIdentifier) {
        AtomicReference atomicReference = new AtomicReference();
        this.findWebElement(webElement -> atomicReference.set(webElement.getCssValue(cssIdentifier)));
        return (String)atomicReference.get();
    }

    @Override
    public void hover() {
        this.pMouseOver();
    }

    protected void highlightWebElement(WebElement webElement, Color color) {
        JSUtils utils = new JSUtils();
        utils.highlight(this.guiElementData.getWebDriver(), webElement, color);
    }

    private void pMouseOver() {
        this.findWebElement(webElement -> {
            this.highlightWebElement((WebElement)webElement, new Color(255, 255, 0));
            Actions action = new Actions(this.guiElementData.getWebDriver());
            action.moveToElement(webElement).build().perform();
        });
    }

    @Override
    public boolean isPresent() {
        try {
            this.findWebElement(webElement -> {});
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public List<String> getTextsFromChildren() {
        return this.pGetTextsFromChildren();
    }

    private List<String> pGetTextsFromChildren() {
        AtomicReference atomicReference = new AtomicReference();
        this.findWebElement(webElement -> {
            List childElements = webElement.findElements(By.xpath((String)".//*"));
            ArrayList<String> childTexts = new ArrayList<String>();
            for (WebElement childElement : childElements) {
                String text = childElement.getText();
                if (text == null || text.equals("")) continue;
                childTexts.add(text);
            }
            atomicReference.set(childTexts);
        });
        return (List)atomicReference.get();
    }

    @Override
    public void doubleClick() {
        this.findWebElement(webElement -> {
            if ("safari".equalsIgnoreCase(((IWebDriverManager)Testerra.getInjector().getInstance(IWebDriverManager.class)).getRequestedBrowser(this.guiElementData.getWebDriver()).orElse(null))) {
                this.log().info("Safari double click workaround");
                JSUtils.executeJavaScriptMouseAction(this.guiElementData.getWebDriver(), webElement, JSMouseAction.DOUBLE_CLICK, 0, 0);
            } else {
                Actions actions = new Actions(this.guiElementData.getWebDriver());
                Action action = actions.moveToElement(webElement).doubleClick(webElement).build();
                try {
                    action.perform();
                }
                catch (InvalidElementStateException e) {
                    this.log().error("Error performing double click", (Throwable)e);
                    this.log().info("Retrying double click with click-click");
                    actions.moveToElement(webElement).click().click().build().perform();
                }
            }
        });
    }

    @Override
    public void highlight(Color color) {
        this.findWebElement(webElement -> this.highlightWebElement((WebElement)webElement, color));
    }

    @Override
    public abstract void swipe(int var1, int var2);

    @Override
    public int getLengthOfValueAfterSendKeys(String textToInput) {
        this.clear();
        this.sendKeys(textToInput);
        int valueLength = this.getAttribute("value").length();
        return valueLength;
    }

    @Override
    public int getNumberOfFoundElements() {
        AtomicInteger atomicInteger = new AtomicInteger();
        this.findWebElements(webElements -> {
            this.filterWebElements((List<WebElement>)webElements);
            atomicInteger.set(webElements.size());
        });
        return atomicInteger.get();
    }

    public String toString() {
        return this.guiElementData.toString();
    }

    @Override
    public void contextClick() {
        this.findWebElement(webElement -> {
            Actions actions = new Actions(this.guiElementData.getWebDriver());
            actions.moveToElement(webElement).contextClick().build().perform();
        });
    }

    @Override
    public File takeScreenshot() {
        boolean isSelenium4 = false;
        AtomicReference atomicReference = new AtomicReference();
        this.findWebElement(webElement -> {
            if (!this.isVisible(false)) {
                this.scrollToTop();
            }
            Rectangle viewport = WebDriverUtils.getViewport(this.guiElementData.getWebDriver());
            try {
                TakesScreenshot driver = (TakesScreenshot)this.guiElementData.getWebDriver();
                File screenshot = (File)driver.getScreenshotAs(OutputType.FILE);
                BufferedImage fullImg = ImageIO.read(screenshot);
                Point elementPosition = webElement.getLocation();
                Dimension elementSize = webElement.getSize();
                int imageX = elementPosition.getX() - viewport.getX();
                int imageY = elementPosition.getY() - viewport.getY();
                int imageWidth = elementSize.getWidth();
                int imageHeight = elementSize.getHeight();
                if (imageX > fullImg.getWidth()) {
                    imageX = 0;
                }
                if (imageY > fullImg.getHeight()) {
                    imageY = 0;
                }
                if (imageX + imageWidth > fullImg.getWidth()) {
                    imageWidth = fullImg.getWidth() - imageX;
                }
                if (imageY + imageHeight > fullImg.getHeight()) {
                    imageHeight = fullImg.getHeight() - imageY;
                }
                BufferedImage eleScreenshot = fullImg.getSubimage(imageX, imageY, imageWidth, imageHeight);
                ImageIO.write((RenderedImage)eleScreenshot, "png", screenshot);
                atomicReference.set(screenshot);
            }
            catch (IOException e) {
                this.log().error(String.format("%s unable to take screenshot: %s ", this.guiElementData, e));
            }
        });
        return (File)atomicReference.get();
    }
}

