/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.internal.core;

import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.exceptions.TimeoutException;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.core.AbstractGuiElementCoreDecorator;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.core.GuiElementCore;
import eu.tsystems.mms.tic.testframework.testing.TestController;
import eu.tsystems.mms.tic.testframework.utils.Sequence;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class GuiElementCoreSequenceDecorator
extends AbstractGuiElementCoreDecorator
implements Loggable {
    private static final TestController.Overrides overrides = (TestController.Overrides)Testerra.getInjector().getInstance(TestController.Overrides.class);

    public GuiElementCoreSequenceDecorator(GuiElementCore core) {
        super(core);
    }

    private void sequenced(boolean throwException, Supplier<Boolean> runnable) {
        Sequence sequence = new Sequence().setTimeoutMs((long)overrides.getTimeoutInSeconds() * 1000L).setWaitMsAfterRun(UiElement.Properties.ELEMENT_WAIT_INTERVAL_MS.asLong().longValue());
        AtomicReference atomicThrowable = new AtomicReference();
        AtomicBoolean atomicSuccess = new AtomicBoolean();
        sequence.run(() -> {
            try {
                atomicSuccess.set((Boolean)runnable.get());
            }
            catch (Throwable throwable) {
                atomicThrowable.set(throwable);
                atomicSuccess.set(false);
            }
            return atomicSuccess.get();
        });
        if (!atomicSuccess.get() && throwException) {
            throw new TimeoutException("Sequence timed out after " + sequence.getDurationMs() / 1000L + "s", (Throwable)atomicThrowable.get());
        }
    }

    @Override
    public void findWebElement(Consumer<WebElement> consumer) {
        this.sequenced(true, () -> {
            this.decoratedCore.findWebElement(consumer);
            return true;
        });
    }

    @Override
    public void scrollToElement(int yOffset) {
        this.sequenced(true, () -> {
            this.decoratedCore.scrollToElement(yOffset);
            return true;
        });
    }

    @Override
    public void scrollIntoView(Point offset) {
        this.sequenced(true, () -> {
            this.decoratedCore.scrollIntoView(offset);
            return true;
        });
    }

    @Override
    public void hover() {
        this.sequenced(true, () -> {
            this.decoratedCore.hover();
            return true;
        });
    }

    @Override
    public void select() {
        this.sequenced(true, () -> {
            this.decoratedCore.select();
            return this.decoratedCore.isSelected();
        });
    }

    @Override
    public void deselect() {
        this.sequenced(true, () -> {
            this.decoratedCore.deselect();
            return !this.decoratedCore.isSelected();
        });
    }

    @Override
    public void type(String text) {
        this.sequenced(true, () -> {
            this.decoratedCore.type(text);
            return true;
        });
    }

    @Override
    public void click() {
        this.sequenced(true, () -> {
            this.decoratedCore.click();
            return true;
        });
    }

    @Override
    public void submit() {
        this.sequenced(true, () -> {
            this.decoratedCore.submit();
            return true;
        });
    }

    @Override
    public void sendKeys(CharSequence ... charSequences) {
        this.sequenced(true, () -> {
            this.decoratedCore.sendKeys(charSequences);
            return true;
        });
    }

    @Override
    public void clear() {
        this.sequenced(true, () -> {
            this.decoratedCore.clear();
            return true;
        });
    }

    @Override
    public String getTagName() {
        AtomicReference atomicReference = new AtomicReference();
        this.sequenced(true, () -> {
            atomicReference.set(this.decoratedCore.getTagName());
            return true;
        });
        return (String)atomicReference.get();
    }

    @Override
    public Point getLocation() {
        AtomicReference atomicReference = new AtomicReference();
        this.sequenced(true, () -> {
            atomicReference.set(this.decoratedCore.getLocation());
            return true;
        });
        return (Point)atomicReference.get();
    }

    @Override
    public Dimension getSize() {
        AtomicReference atomicReference = new AtomicReference();
        this.sequenced(true, () -> {
            atomicReference.set(this.decoratedCore.getSize());
            return true;
        });
        return (Dimension)atomicReference.get();
    }

    @Override
    public String getCssValue(String cssIdentifier) {
        AtomicReference atomicReference = new AtomicReference();
        this.sequenced(true, () -> {
            atomicReference.set(this.decoratedCore.getCssValue(cssIdentifier));
            return true;
        });
        return (String)atomicReference.get();
    }

    @Override
    public List<String> getTextsFromChildren() {
        AtomicReference atomicReference = new AtomicReference();
        this.sequenced(true, () -> {
            atomicReference.set(this.decoratedCore.getTextsFromChildren());
            return true;
        });
        return (List)atomicReference.get();
    }

    @Override
    public void doubleClick() {
        this.sequenced(true, () -> {
            this.decoratedCore.doubleClick();
            return true;
        });
    }

    @Override
    public void highlight(Color color) {
        this.sequenced(true, () -> {
            this.decoratedCore.highlight(color);
            return true;
        });
    }

    @Override
    public void swipe(int offsetX, int offSetY) {
        this.sequenced(true, () -> {
            this.decoratedCore.swipe(offsetX, offSetY);
            return true;
        });
    }

    @Override
    public int getLengthOfValueAfterSendKeys(String textToInput) {
        AtomicInteger atomicReference = new AtomicInteger();
        this.sequenced(true, () -> {
            atomicReference.set(this.decoratedCore.getLengthOfValueAfterSendKeys(textToInput));
            return true;
        });
        return atomicReference.get();
    }

    @Override
    public int getNumberOfFoundElements() {
        AtomicInteger atomicReference = new AtomicInteger();
        this.sequenced(true, () -> {
            atomicReference.set(this.decoratedCore.getNumberOfFoundElements());
            return true;
        });
        return atomicReference.get();
    }

    @Override
    public File takeScreenshot() {
        AtomicReference atomicReference = new AtomicReference();
        this.sequenced(true, () -> {
            atomicReference.set(this.decoratedCore.takeScreenshot());
            return true;
        });
        return (File)atomicReference.get();
    }

    @Override
    public String getText() {
        AtomicReference atomicReference = new AtomicReference();
        this.sequenced(true, () -> {
            atomicReference.set(this.decoratedCore.getText());
            return true;
        });
        return (String)atomicReference.get();
    }

    @Override
    public String getAttribute(String attributeName) {
        AtomicReference atomicReference = new AtomicReference();
        this.sequenced(true, () -> {
            atomicReference.set(this.decoratedCore.getAttribute(attributeName));
            return true;
        });
        return (String)atomicReference.get();
    }

    @Override
    public boolean isPresent() {
        AtomicBoolean atomicReference = new AtomicBoolean();
        this.sequenced(false, () -> {
            atomicReference.set(this.decoratedCore.isPresent());
            return atomicReference.get();
        });
        return atomicReference.get();
    }

    @Override
    public boolean isEnabled() {
        AtomicBoolean atomicReference = new AtomicBoolean();
        this.sequenced(false, () -> {
            atomicReference.set(this.decoratedCore.isEnabled());
            return atomicReference.get();
        });
        return atomicReference.get();
    }

    @Override
    public boolean isDisplayed() {
        AtomicBoolean atomicReference = new AtomicBoolean();
        this.sequenced(false, () -> {
            atomicReference.set(this.decoratedCore.isDisplayed());
            return atomicReference.get();
        });
        return atomicReference.get();
    }

    @Override
    public boolean isVisible(boolean fullyVisible) {
        AtomicBoolean atomicReference = new AtomicBoolean();
        this.sequenced(false, () -> {
            atomicReference.set(this.decoratedCore.isVisible(fullyVisible));
            return atomicReference.get();
        });
        return atomicReference.get();
    }

    @Override
    public boolean isSelected() {
        AtomicBoolean atomicReference = new AtomicBoolean();
        this.sequenced(false, () -> {
            atomicReference.set(this.decoratedCore.isSelected());
            return atomicReference.get();
        });
        return atomicReference.get();
    }

    @Override
    public boolean isSelectable() {
        AtomicBoolean atomicReference = new AtomicBoolean();
        this.sequenced(false, () -> {
            atomicReference.set(this.decoratedCore.isSelectable());
            return atomicReference.get();
        });
        return atomicReference.get();
    }
}

