/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.pageobjects.internal.core;

import eu.tsystems.mms.tic.testframework.internal.Nameable;
import eu.tsystems.mms.tic.testframework.pageobjects.GuiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.Locator;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.DefaultLocator;
import eu.tsystems.mms.tic.testframework.webdriver.WebDriverRetainer;
import org.openqa.selenium.WebDriver;

public class GuiElementData
implements Nameable<GuiElementData>,
WebDriverRetainer {
    private final DefaultLocator locate;
    private final WebDriver webDriver;
    private GuiElementData parent;
    private int index = -1;
    private GuiElement guiElement;
    private String name;
    private boolean shadowRoot = false;
    private boolean sensibleData = false;
    private boolean isFrame = false;

    public GuiElementData(GuiElementData parent, Locator locator) {
        this(parent.webDriver, locator);
        this.parent = parent;
        this.guiElement = parent.guiElement;
    }

    public GuiElementData(GuiElementData parent, int index) {
        this(parent.webDriver, (Locator)parent.locate);
        this.index = index;
        this.parent = parent.parent;
        this.name = parent.name;
        this.guiElement = parent.guiElement;
        this.shadowRoot = parent.shadowRoot;
    }

    public GuiElementData(WebDriver webDriver, Locator locator) {
        this.webDriver = webDriver;
        this.locate = (DefaultLocator)locator;
    }

    public GuiElementData setGuiElement(GuiElement guiElement) {
        this.guiElement = guiElement;
        return this;
    }

    public GuiElement getGuiElement() {
        return this.guiElement;
    }

    public GuiElementData getParent() {
        return this.parent;
    }

    public boolean hasOwnName() {
        return this.name != null;
    }

    public DefaultLocator getLocate() {
        return this.locate;
    }

    @Override
    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    public boolean isShadowRoot() {
        return this.shadowRoot;
    }

    public GuiElementData setHasShadowRoot(boolean shadowRoot) {
        this.shadowRoot = shadowRoot;
        return this;
    }

    public boolean hasSensibleData() {
        return this.sensibleData;
    }

    public GuiElementData setHasSensibleData(boolean sensibleData) {
        this.sensibleData = sensibleData;
        return this;
    }

    public String toString() {
        return this.toString(false);
    }

    public String getName(boolean detailed) {
        StringBuilder sb = new StringBuilder();
        boolean hasName = this.hasOwnName();
        if (hasName) {
            sb.append(this.name);
        } else {
            sb.append(UiElement.class.getSimpleName());
        }
        if (!hasName || detailed) {
            sb.append("(").append(this.locate);
            if (this.index != -1) {
                sb.append("[").append(this.index + 1).append("]");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public GuiElementData setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isFrame() {
        return this.isFrame;
    }

    public GuiElementData setIsFrame(boolean frame) {
        this.isFrame = frame;
        return this;
    }
}

