/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

public class DefaultCapabilityUtils
implements Loggable {
    public Map<String, Object> clean(Capabilities capabilities) {
        return this.clean(capabilities.asMap());
    }

    public Map<String, Object> clean(Map<String, Object> capabilityMap) {
        Gson gson = new GsonBuilder().create();
        String json = gson.toJson(capabilityMap);
        Map clonedMap = (Map)gson.fromJson(json, Map.class);
        this.shortMapValues(clonedMap);
        return Collections.unmodifiableMap(clonedMap);
    }

    private void shortMapValues(Map<String, Object> map2Short) {
        List<String> exceptionList = List.of("path");
        try {
            for (Map.Entry<String, Object> entry : map2Short.entrySet()) {
                Object value = entry.getValue();
                String key = entry.getKey();
                if (value instanceof Map) {
                    Map subMap = (Map)value;
                    this.shortMapValues(subMap);
                    continue;
                }
                String stringValue = String.valueOf(value);
                if (stringValue.length() <= 40 || exceptionList.contains(key)) continue;
                entry.setValue(stringValue.substring(0, 40) + "...");
            }
        }
        catch (Exception e) {
            this.log().debug("Cannot clean map: ", (Throwable)e);
        }
    }

    public <T> void putIfAbsent(DesiredCapabilities capabilities, String capabilityName, T capability) {
        Object existingCapability = capabilities.getCapability(capabilityName);
        if (!capability.getClass().isInstance(existingCapability) || existingCapability instanceof String && StringUtils.isBlank((CharSequence)((String)existingCapability))) {
            capabilities.setCapability(capabilityName, capability);
        }
    }
}

