/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.utils;

import eu.tsystems.mms.tic.testframework.utils.CertUtils;
import eu.tsystems.mms.tic.testframework.utils.WebDriverUtils;
import java.net.URLConnection;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.net.ssl.HttpsURLConnection;
import org.openqa.selenium.WebDriver;

public class DefaultConnectionConfigurator
implements Consumer<URLConnection> {
    private final Map<String, String> headers = new HashMap<String, String>();
    private CertUtils certUtils;
    private Duration timeout;

    public DefaultConnectionConfigurator() {
        this.setTimeout(Duration.ofSeconds(10L));
    }

    public DefaultConnectionConfigurator imitateCookiesFrom(WebDriver webDriver) {
        this.headers.put("Cookie", WebDriverUtils.getCookieString(webDriver));
        return this;
    }

    public DefaultConnectionConfigurator useCertUtils(CertUtils certUtils) {
        this.certUtils = certUtils;
        return this;
    }

    public DefaultConnectionConfigurator setUserAgent(String userAgent) {
        this.headers.put("User-Agent", userAgent);
        return this;
    }

    public DefaultConnectionConfigurator setHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public DefaultConnectionConfigurator setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public void accept(URLConnection urlConnection) {
        if (urlConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)urlConnection;
            if (this.certUtils != null) {
                httpsURLConnection.setSSLSocketFactory(this.certUtils.createTrustingSslSocketFactory());
                httpsURLConnection.setHostnameVerifier(this.certUtils.getHostnameVerifier());
            }
        }
        if (this.timeout != null) {
            Long timeout = this.timeout.toMillis();
            urlConnection.setConnectTimeout(timeout.intValue());
            urlConnection.setReadTimeout(timeout.intValue());
        }
        this.headers.forEach(urlConnection::setRequestProperty);
    }
}

