/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.utils;

import eu.tsystems.mms.tic.testframework.exceptions.SystemException;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.pageobjects.Attribute;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.utils.CertUtils;
import eu.tsystems.mms.tic.testframework.utils.FileUtils;
import eu.tsystems.mms.tic.testframework.utils.WebDriverUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.FilenameUtils;
import org.openqa.selenium.WebDriver;

public class FileDownloader
implements Loggable {
    private static int DEFAULT_TIMEOUT_MS = 10000;
    private static final List<String> downloadList = new ArrayList<String>();
    private String downloadLocation = FileUtils.getTempDirectoryPath();
    private boolean imitateCookies = true;
    private boolean trustAllCertificates = true;
    private Proxy proxy = null;
    private Consumer<URLConnection> connectionConfigurator;

    public FileDownloader(String downloadLocation, boolean imitateCookies, boolean trustAllCertificates) {
        this.downloadLocation = downloadLocation;
        this.imitateCookies = imitateCookies;
        this.trustAllCertificates = trustAllCertificates;
    }

    public FileDownloader(String downloadLocation) {
        this.downloadLocation = downloadLocation;
    }

    public FileDownloader() {
    }

    public FileDownloader setConnectionConfigurator(Consumer<URLConnection> connectionConfigurator) {
        this.connectionConfigurator = connectionConfigurator;
        return this;
    }

    @Deprecated
    public static void deleteDownloads() {
        new FileDownloader().cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDownloader cleanup() {
        List<String> list = downloadList;
        synchronized (list) {
            for (String path : downloadList) {
                File file = FileUtils.getFile((String[])new String[]{path});
                if (file.delete()) continue;
                this.log().warn(String.format("File >%s< couldn't be deleted on cleanup. Please remove file manually.", file.getAbsolutePath()));
            }
            downloadList.clear();
        }
        return this;
    }

    public String getDownloadLocation() {
        return this.downloadLocation;
    }

    public FileDownloader setDownloadLocation(String downloadLocation) {
        this.downloadLocation = downloadLocation;
        return this;
    }

    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public FileDownloader setTrustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = trustAllCertificates;
        return this;
    }

    public boolean isImitateCookies() {
        return this.imitateCookies;
    }

    public FileDownloader setImitateCookies(boolean value) {
        this.imitateCookies = value;
        return this;
    }

    public File download(UiElement element) throws IOException {
        return new File(this.download(element, null));
    }

    public String download(UiElement element, String targetFileName) throws IOException {
        this.log().debug("Try to get href attribute of GuiElement");
        String link = (String)element.waitFor().attribute(Attribute.HREF).getActual();
        if (link == null || link.length() == 0) {
            this.log().debug("No href attribute found. Try src attribute.");
            link = (String)element.waitFor().attribute(Attribute.SRC).getActual();
        }
        if (link == null || link.length() == 0) {
            throw new SystemException("Neither href nor src attribute found on GuiElement.");
        }
        return this.download(element.getWebDriver(), link, targetFileName);
    }

    public File download(URL url) throws IOException {
        return this.download(url.toString());
    }

    public File download(String urlString) throws IOException {
        return this.download(urlString, null);
    }

    public File download(URL url, String targetFileName) throws IOException {
        return this.download(url.toString(), targetFileName);
    }

    public File download(String urlString, String targetFileName) throws IOException {
        return new File(this.pDownload(null, urlString, targetFileName, DEFAULT_TIMEOUT_MS));
    }

    public File download(WebDriver driver, String urlString) throws IOException {
        String filePath = this.download(driver, urlString, null);
        return new File(filePath);
    }

    public String download(WebDriver driver, String url, String targetFileName) throws IOException {
        return this.pDownload(driver, url, targetFileName, DEFAULT_TIMEOUT_MS);
    }

    public String download(WebDriver driver, String url, String targetFileName, int timeoutMS) throws IOException {
        return this.pDownload(driver, url, targetFileName, timeoutMS);
    }

    private String pDownload(WebDriver driver, String urlString, String targetFileName, int timeoutMS) throws IOException {
        String cookieString = null;
        if (this.isImitateCookies() && driver != null) {
            cookieString = WebDriverUtils.getCookieString(driver);
        }
        this.ensureLocationExists();
        File targetFile = null;
        if (targetFileName != null) {
            targetFile = FileUtils.getFile((String[])new String[]{this.getDownloadLocation() + "/" + targetFileName});
        }
        URL url = new URL(urlString);
        return this.download(url, targetFile, this.proxy, timeoutMS, this.trustAllCertificates, null, cookieString, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String download(URL url, File targetFile, Proxy proxy, int timeoutMS, boolean trustAll, SSLSocketFactory sslSocketFactory, String cookieString, boolean useSecondConnection) throws IOException {
        this.log().info("Start downloading " + url);
        String targetFileName = "";
        URLConnection connection = this.openConnection(url, proxy, timeoutMS, trustAll, cookieString, sslSocketFactory);
        if (connection instanceof HttpURLConnection) {
            targetFileName = this.readFileNameFromConnection((HttpURLConnection)connection);
        }
        InputStream inputStream = connection.getInputStream();
        if (targetFile == null) {
            if (targetFileName.isEmpty()) {
                targetFileName = FilenameUtils.getBaseName((String)url.getPath());
            }
            targetFile = FileUtils.getFile((String[])new String[]{this.getDownloadLocation() + "/" + targetFileName});
        }
        this.log().info("Downloaded " + url + " to " + targetFile.getAbsolutePath());
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)targetFile);
        List<String> list = downloadList;
        synchronized (list) {
            downloadList.add(targetFile.getAbsolutePath());
        }
        return targetFile.getAbsolutePath();
    }

    private String readFileNameFromConnection(HttpURLConnection connection) {
        Pattern pattern;
        Matcher matcher;
        String fileName = "";
        String disposition = connection.getHeaderField("Content-Disposition");
        if (disposition != null && (matcher = (pattern = Pattern.compile("filename=\\\"?([^\\\"]+)\\\"?")).matcher(disposition)).find()) {
            return matcher.group(1);
        }
        return fileName;
    }

    private URLConnection openConnection(URL url, Proxy proxy, int timeoutMS, boolean trustAll, String cookieString, SSLSocketFactory sslSocketFactory) throws IOException {
        URLConnection connection;
        if (proxy == null) {
            connection = url.openConnection();
        } else {
            connection = url.openConnection(proxy);
            this.log().info("Using proxy " + proxy);
        }
        if (this.connectionConfigurator != null) {
            this.connectionConfigurator.accept(connection);
        } else {
            connection.setConnectTimeout(timeoutMS);
            connection.setReadTimeout(timeoutMS);
            if (trustAll && FileDownloader.isHttpsUrl(url)) {
                this.log().info("Trust all certificates on download is set to " + trustAll);
                connection = CertUtils.trustAllCerts((HttpsURLConnection)((HttpsURLConnection)connection), (SSLSocketFactory)sslSocketFactory);
            }
            if (cookieString != null) {
                this.log().info("Imitating cookies");
                connection.setRequestProperty("Cookie", cookieString);
            }
        }
        return connection;
    }

    private static boolean isHttpsUrl(URL url) {
        return url.getProtocol().toLowerCase().equals("https");
    }

    private boolean ensureLocationExists() {
        File downloadLoc = FileUtils.getFile((String[])new String[]{this.getDownloadLocation()});
        return downloadLoc.exists() || downloadLoc.mkdirs();
    }

    public static void setDefaultTimeoutMs(int defaultTimeoutMs) {
        DEFAULT_TIMEOUT_MS = defaultTimeoutMs;
    }

    public FileDownloader setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }
}

