/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.constants.JSMouseAction;
import eu.tsystems.mms.tic.testframework.exceptions.NotYetImplementedException;
import eu.tsystems.mms.tic.testframework.exceptions.SystemException;
import eu.tsystems.mms.tic.testframework.internal.StopWatch;
import eu.tsystems.mms.tic.testframework.pageobjects.GuiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.UiElement;
import eu.tsystems.mms.tic.testframework.pageobjects.internal.core.GuiElementData;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JSUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSUtils.class);

    public void addJavascriptResources(WebDriver webDriver, Stream<String> resourceFiles) {
        JSUtils.executeScript(webDriver, JSUtils.readScriptResources(resourceFiles), new Object[0]);
    }

    @Deprecated
    public static void implementJavascriptOnPage(WebDriver driver, String resourceFile, String id) {
        if (JSUtils.isJavascriptImplementedOnPage(driver, id)) {
            LOGGER.warn("Already injected: " + resourceFile);
            return;
        }
        String inline = JSUtils.readScriptResources(Stream.of(resourceFile));
        JSUtils.implementJavascriptOnPage(id, driver, inline);
    }

    private static void implementJavascriptOnPage(String scriptId, WebDriver driver, String script) {
        try {
            if (script.length() > 0) {
                Gson gson = new GsonBuilder().create();
                JavascriptExecutor javascriptExecutor = (JavascriptExecutor)driver;
                String injectedScript = String.format("var script=document.createElement('script');var text=document.createTextNode(%s);script.type='text/javascript';script.id=%s;script.appendChild(text);document.body.appendChild(script);", gson.toJson((Object)script), gson.toJson((Object)scriptId));
                javascriptExecutor.executeScript(injectedScript, new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error executing javascript: " + e.getMessage(), (Throwable)e);
        }
    }

    public static Object executeAsyncScript(WebDriver driver, String script, Object ... parameters) {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)driver;
        return javascriptExecutor.executeAsyncScript(script, parameters);
    }

    public static Object executeScriptWOCatch(WebDriver driver, String script, Object ... parameters) {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)driver;
        return javascriptExecutor.executeScript(script, parameters);
    }

    public static Object executeScript(WebDriver driver, String script, Object ... parameters) {
        try {
            return JSUtils.executeScriptWOCatch(driver, script, parameters);
        }
        catch (Exception e) {
            Object message = String.format("Error executing Javascript\n-----\n%s\n-----", script);
            if (parameters.length > 0) {
                message = (String)message + "\nwith parameters:\n" + Arrays.stream(parameters).map(o -> o == null ? "null" : o.toString()).collect(Collectors.joining("\n"));
                message = (String)message + "\n-----";
            }
            LOGGER.error((String)message, (Throwable)e);
            return null;
        }
    }

    public void highlight(WebDriver webDriver, WebElement webElement, Color color) {
        JSUtils.highlightWebElement(webDriver, webElement, color);
    }

    public static void highlightWebElement(WebDriver driver, WebElement webElement, Color color) {
        int ms = 2000;
        try {
            JSUtils.executeScriptWOCatch(driver, String.format("%s\nttHighlight(arguments[0], '%s', %d)", JSUtils.readSnippets(Snippet.HIGHLIGHT), JSUtils.toHex(color), ms), webElement);
        }
        catch (Exception e) {
            LOGGER.error("Unable to highlight WebElement: " + e.getMessage());
        }
    }

    private static String readSnippets(Snippet ... snippets) {
        return JSUtils.readScriptResources(Arrays.stream(snippets).map(Snippet::getResourcePath));
    }

    private static String readScriptResources(Stream<String> resourceFiles) {
        StringBuilder sb = new StringBuilder();
        resourceFiles.forEach(resourceFile -> {
            try {
                sb.append(new String(IOUtils.toByteArray((InputStream)Objects.requireNonNull(JSUtils.class.getClassLoader().getResourceAsStream((String)resourceFile)))));
            }
            catch (IOException e) {
                LOGGER.error("Unable to read resourceFile", (Throwable)e);
            }
        });
        return sb.toString();
    }

    private static String toHex(Color color) {
        return String.format("#%02x%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private static boolean isJavascriptImplementedOnPage(WebDriver driver, String id) {
        List script = driver.findElements(By.xpath((String)(".//script[@id='" + id + "']")));
        return script.size() > 0;
    }

    public static void executeJavaScriptMouseAction(WebDriver driver, WebElement containerWebElement, JSMouseAction type, int x, int y) {
        String aimedElement = "arguments[0]";
        if (containerWebElement == null) {
            aimedElement = "document";
        }
        ((JavascriptExecutor)driver).executeScript("var evt = document.createEvent('MouseEvents'); evt.initMouseEvent('" + type.getActionCommand() + "',true, true, window, 0, 0, 0," + x + "," + y + ", false, false, false, false, 0,null); " + aimedElement + ".dispatchEvent(evt);", new Object[]{containerWebElement});
    }

    public void scrollToTop(WebDriver webDriver) {
        JavascriptExecutor jsExecutor = (JavascriptExecutor)webDriver;
        jsExecutor.executeScript("scroll(0,0);", new Object[0]);
    }

    public void scrollElementToTop(WebDriver webDriver, WebElement webElement) {
        JSUtils.executeScript(webDriver, "window.scrollTo({ top: arguments[0].offsetTop, left: arguments[0].offsetLeft });", webElement);
    }

    @Deprecated
    public static String getJavaScriptSelector(GuiElement element) {
        String jsFrameExpander = ".contentDocument";
        Object hierarchyFrameSelector = "document";
        GuiElementData guiElementData = element.getData();
        for (GuiElementData parentData = guiElementData.getParent(); parentData != null && parentData.isFrame(); parentData = parentData.getParent()) {
            hierarchyFrameSelector = JSUtils.pGetSimpleJsSelector(parentData, (String)hierarchyFrameSelector) + ".contentDocument";
        }
        String fullSelector = JSUtils.pGetSimpleJsSelector(guiElementData, (String)hierarchyFrameSelector);
        return fullSelector;
    }

    private static String pGetSimpleJsSelector(GuiElementData guiElementData, String documentSelector) {
        String jsById = documentSelector + ".getElementById(\"###\")";
        String jsByClassName = documentSelector + ".getElementsByClassName(\"###\")[0]";
        String jsByTagName = documentSelector + ".getElementsByTagName(\"###\")[0]";
        String jsByCssSelector = documentSelector + ".querySelector(\"###\")";
        String jsByName = documentSelector + ".querySelector(*[name='###'])";
        String jsByXpath = documentSelector + ".evaluate(\"###\", " + documentSelector + ", null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue";
        String jsByLinkText = documentSelector + ".evaluate(\".//a[text()='###']\", " + documentSelector + ", null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue";
        String jsByPartialLinkText = documentSelector + ".evaluate(\".//a[contains(text(), '###')]\", " + documentSelector + ", null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue";
        By by = guiElementData.getLocate().getBy();
        String beautifiedSelector = JSUtils.beautifySelectorString(by);
        Object jsSelector = "";
        if (by instanceof By.ById) {
            jsSelector = jsById;
        } else if (by instanceof By.ByCssSelector) {
            jsSelector = jsByCssSelector;
        } else if (by instanceof By.ByXPath) {
            jsSelector = jsByXpath;
        } else if (by instanceof By.ByClassName) {
            jsSelector = jsByClassName;
        } else if (by instanceof By.ByLinkText) {
            jsSelector = jsByLinkText;
        } else if (by instanceof By.ByPartialLinkText) {
            jsSelector = jsByPartialLinkText;
        } else if (by instanceof By.ByTagName) {
            jsSelector = jsByTagName;
        } else if (by instanceof By.ByName) {
            jsSelector = jsByName;
        }
        return ((String)jsSelector).replace("###", beautifiedSelector);
    }

    private static String beautifySelectorString(By selector) {
        return selector.toString().replaceFirst("By.*:", "").trim();
    }

    @Deprecated
    public static Map<String, Long> getElementInnerBorders(UiElement guiElement) {
        String cmd = "el = arguments[0];bl = window.getComputedStyle(el, null).getPropertyValue('border-left-width');br = window.getComputedStyle(el, null).getPropertyValue('border-right-width');bt = window.getComputedStyle(el, null).getPropertyValue('border-top-width');bb = window.getComputedStyle(el, null).getPropertyValue('border-bottom-width');pl = window.getComputedStyle(el, null).getPropertyValue('padding-left');pr = window.getComputedStyle(el, null).getPropertyValue('padding-right');pt = window.getComputedStyle(el, null).getPropertyValue('padding-top');pb = window.getComputedStyle(el, null).getPropertyValue('padding-bottom');bl = bl.replace('px','');br = br.replace('px','');bt = bt.replace('px','');bb = bb.replace('px','');pl = pl.replace('px','');pr = pr.replace('px','');pt = pt.replace('px','');pb = pb.replace('px','');l = el.getBoundingClientRect().x;w = el.getBoundingClientRect().width;t = el.getBoundingClientRect().y;h = el.getBoundingClientRect().height;il = parseInt(l);iw = parseInt(w);it = parseInt(t);ih = parseInt(h);ibl = parseInt(bl);ibr = parseInt(br);ibt = parseInt(bt);ibb = parseInt(bb);ipl = parseInt(pl);ipr = parseInt(pr);ipt = parseInt(pt);ipb = parseInt(pb);x = il + ipl + ibl;xx = il + iw - ibr - ipr;y = it + ipt + ibt;yy = it + ih - ibb - ipb;return {left:x, right:xx, top:y, bottom:yy};";
        WebDriver driver = guiElement.getWebDriver();
        ConcurrentHashMap<String, Long> out = new ConcurrentHashMap<String, Long>();
        guiElement.findWebElement(webElement -> {
            try {
                Object o = JSUtils.executeScript(driver, cmd, webElement);
                if (o != null && o instanceof Map) {
                    Map map = (Map)o;
                    for (Object key2 : map.keySet()) {
                        Object value = map.get(key2);
                        if (!(key2 instanceof String) || !(value instanceof Long)) continue;
                        out.put((String)key2, (Long)value);
                    }
                    out.keySet().forEach(key -> LOGGER.info(key + "=" + out.get(key)));
                    if (out.keySet().size() != 4) {
                        throw new RuntimeException("Could not get element border via JS call");
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not determine element inner left position", (Throwable)e);
            }
        });
        return out;
    }

    public Rectangle getViewport(WebDriver driver) {
        Object result = JSUtils.executeScript(driver, "return [window.pageXOffset.toString(), window.pageYOffset.toString(), window.innerWidth.toString(), window.innerHeight.toString()];", new Object[0]);
        if (result != null) {
            ArrayList list = (ArrayList)result;
            List numbers = list.stream().map(Double::valueOf).collect(Collectors.toList());
            return new Rectangle(((Double)numbers.get(0)).intValue(), ((Double)numbers.get(1)).intValue(), ((Double)numbers.get(3)).intValue(), ((Double)numbers.get(2)).intValue());
        }
        return new Rectangle(-1, -1, -1, -1);
    }

    private static int getJSValueAsInt(Object in) {
        if (in instanceof Double) {
            return (int)((Double)in).doubleValue();
        }
        if (in instanceof Long) {
            return (int)((Long)in).longValue();
        }
        LOGGER.error("Cannot cast JS value into int: " + in);
        if (in == null) {
            return 0;
        }
        return 0;
    }

    public static Point getElementLocationInParent(UiElement guiElement, Where where) {
        AtomicReference atomicPoint = new AtomicReference();
        guiElement.findWebElement(webElement -> {
            Object o = JSUtils.executeScript(guiElement.getWebDriver(), "return arguments[0].getBoundingClientRect();", webElement);
            if (o == null) {
                throw new SystemException("Could not get information about web element, please see the logs");
            }
            Map m = (Map)o;
            int left = JSUtils.getJSValueAsInt(m.get("left"));
            int width = JSUtils.getJSValueAsInt(m.get("width"));
            int height = JSUtils.getJSValueAsInt(m.get("height"));
            int top = JSUtils.getJSValueAsInt(m.get("top"));
            switch (where) {
                case CENTER: {
                    atomicPoint.set(new Point(left + width / 2, top + height / 2));
                    break;
                }
                case TOP_LEFT: {
                    atomicPoint.set(new Point(left, top));
                    break;
                }
                default: {
                    throw new NotYetImplementedException("" + where);
                }
            }
        });
        return (Point)atomicPoint.get();
    }

    public void scrollToCenter(WebDriver webDriver, WebElement webElement, Point offset) {
        JSUtils.executeScript(webDriver, String.format("const elementRect = arguments[0].getBoundingClientRect();\nconst absoluteElementTop = elementRect.top + window.pageYOffset;\nconst absoluteElementLeft = elementRect.left + window.pageXOffset;\nconst middle = absoluteElementTop - (window.innerHeight / 2);\nconst center = absoluteElementLeft - (window.innerWidth / 2);\nwindow.scrollTo(center+%d, middle+%d);", offset.x, offset.y), webElement);
    }

    public void mouseOver(WebDriver webDriver, WebElement webElement) {
        this.demoMouseOver(webDriver, webElement);
        this.pMouseOverJS(webDriver, webElement);
    }

    public void doubleClick(WebDriver webDriver, WebElement webElement) {
        Point location = webElement.getLocation();
        JSUtils.executeJavaScriptMouseAction(webDriver, webElement, JSMouseAction.DOUBLE_CLICK, location.getX(), location.getY());
    }

    public void rightClick(WebDriver webDriver, WebElement webElement) {
        String script = "var element = arguments[0];var e = element.ownerDocument.createEvent('MouseEvents');e.initMouseEvent('contextmenu', true, true,element.ownerDocument.defaultView, 1, 0, 0, 0, 0, false,false, false, false,2, null);return !element.dispatchEvent(e);";
        JSUtils.executeScript(webDriver, script, webElement);
    }

    public void click(WebDriver webDriver, WebElement webElement) {
        JSUtils.executeScript(webDriver, "arguments[0].click();", webElement);
    }

    private void demoMouseOver(WebDriver webDriver, WebElement webElement) {
        if (Testerra.Properties.DEMO_MODE.asBool().booleanValue()) {
            JSUtils.highlightWebElement(webDriver, webElement, new Color(255, 255, 0));
        }
    }

    public void clickAbsolute(WebDriver webDriver, WebElement webElement) {
        this.pClickAbsolute(webDriver, webElement);
    }

    public void mouseOverAbsolute2Axis(WebDriver webDriver, WebElement webElement) {
        this.demoMouseOver(webDriver, webElement);
        this.pMouseOverAbsolute2Axis(webDriver, webElement);
    }

    private void pMouseOverJS(WebDriver webDriver, WebElement webElement) {
        String code = "var fireOnThis = arguments[0];var evObj = document.createEvent('MouseEvents');evObj.initEvent( 'mouseover', true, true );fireOnThis.dispatchEvent(evObj);";
        ((JavascriptExecutor)webDriver).executeScript("var fireOnThis = arguments[0];var evObj = document.createEvent('MouseEvents');evObj.initEvent( 'mouseover', true, true );fireOnThis.dispatchEvent(evObj);", new Object[]{webElement});
    }

    private void pClickAbsolute(WebDriver driver, WebElement webElement) {
        StopWatch.startPageLoad(driver);
        Point point = webElement.getLocation();
        Actions action = new Actions(driver);
        action.moveToElement(webElement, 1 + -point.getX(), 1 + -point.getY());
        action.moveByOffset(0, point.getY()).moveByOffset(point.getX(), 0);
        action.moveToElement(webElement);
        action.moveByOffset(1, 1);
        action.click().perform();
    }

    private void pMouseOverAbsolute2Axis(WebDriver driver, WebElement webElement) {
        Actions action = new Actions(driver);
        Point point = webElement.getLocation();
        action.moveToElement(webElement, 1 + -point.getX(), 1 + -point.getY()).perform();
        action.moveByOffset(0, point.getY()).moveByOffset(point.getX(), 0).perform();
        action.moveToElement(webElement).perform();
    }

    static enum Where {
        CENTER,
        TOP_LEFT;

    }

    private static enum Snippet {
        HIGHLIGHT("snippets/highlight.js");

        private final String resourcePath;

        private Snippet(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }
    }
}

