/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.utils;

import eu.tsystems.mms.tic.testframework.common.PropertyManager;
import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.report.Report;
import eu.tsystems.mms.tic.testframework.report.model.context.AbstractContext;
import eu.tsystems.mms.tic.testframework.report.model.context.MethodContext;
import eu.tsystems.mms.tic.testframework.report.model.context.Screenshot;
import eu.tsystems.mms.tic.testframework.report.model.context.SessionContext;
import eu.tsystems.mms.tic.testframework.report.utils.IExecutionContextController;
import eu.tsystems.mms.tic.testframework.testing.WebDriverManagerProvider;
import eu.tsystems.mms.tic.testframework.utils.ExecutionUtils;
import eu.tsystems.mms.tic.testframework.utils.FileUtils;
import eu.tsystems.mms.tic.testframework.utils.JSUtils;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverSessionsManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UITestUtils
implements WebDriverManagerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(UITestUtils.class);
    private static final ExecutionUtils executionUtils = (ExecutionUtils)Testerra.getInjector().getInstance(ExecutionUtils.class);
    private static final DateFormat FILES_DATE_FORMAT = new SimpleDateFormat("dd_MM_yyyy__HH_mm_ss");
    private static final Report report = (Report)Testerra.getInjector().getInstance(Report.class);
    private static final IExecutionContextController executionContextController = (IExecutionContextController)Testerra.getInjector().getInstance(IExecutionContextController.class);
    private static final int IE_SCREENSHOT_LIMIT = 1200;

    @Deprecated
    private UITestUtils() {
    }

    public static Screenshot takeScreenshot(WebDriver driver, boolean intoReport) {
        String handle = executionUtils.getFailsafe(() -> ((WebDriver)driver).getWindowHandle()).orElse("");
        Screenshot screenshot = UITestUtils.takeScreenshot(driver, handle);
        if (intoReport) {
            IExecutionContextController executionContextController = (IExecutionContextController)Testerra.getInjector().getInstance(IExecutionContextController.class);
            executionContextController.getCurrentMethodContext().ifPresent(methodContext -> {
                methodContext.addScreenshot(screenshot);
                report.addScreenshot(screenshot, Report.FileMode.MOVE);
            });
        }
        return screenshot;
    }

    public static void takeScreenshot(WebDriver webDriver, Screenshot screenshot) {
        Optional<SessionContext> sessionContext = WEB_DRIVER_MANAGER.getSessionContext(webDriver);
        File screenshotFile = screenshot.getScreenshotFile();
        UITestUtils.takeWebDriverScreenshotToFile(webDriver, screenshotFile);
        executionUtils.getFailsafe(() -> ((WebDriver)webDriver).getPageSource()).ifPresent(pageSource -> UITestUtils.savePageSource(pageSource, screenshot.createPageSourceFile()));
        Map metaData = screenshot.getMetaData();
        sessionContext.flatMap(SessionContext::getRemoteSessionId).ifPresent(s -> metaData.put("remoteSessionId", s));
        sessionContext.map(SessionContext::getSessionKey).ifPresent(s -> metaData.put("SessionKey", s));
        sessionContext.map(AbstractContext::getId).ifPresent(s -> metaData.put("sessionContextId", s));
        executionUtils.getFailsafe(() -> ((WebDriver)webDriver).getTitle()).ifPresent(s -> metaData.put("Title", s));
        executionUtils.getFailsafe(() -> ((WebDriver)webDriver).getCurrentUrl()).ifPresent(s -> metaData.put("URL", s));
        Object window = "#1/1";
        String windowHandle = executionUtils.getFailsafe(() -> ((WebDriver)webDriver).getWindowHandle()).orElse("");
        if (StringUtils.isNotBlank((CharSequence)windowHandle)) {
            Set windowHandles = webDriver.getWindowHandles();
            if (windowHandles.size() > 2) {
                String[] handleStrings = windowHandles.toArray(new String[0]);
                for (int i = 0; i < handleStrings.length; ++i) {
                    if (!handleStrings[i].equals(windowHandle)) continue;
                    window = "#" + (i + 1) + "/" + handleStrings.length;
                }
            }
            metaData.put("Window", window);
        }
    }

    public static List<Screenshot> takeScreenshots() {
        return UITestUtils.takeScreenshots(true);
    }

    public static List<Screenshot> takeScreenshots(boolean publishToReport) {
        List<Screenshot> result;
        Optional methodContext = executionContextController.getCurrentMethodContext();
        if (methodContext.isEmpty()) {
            LOGGER.warn("Please use this method only in test or setup methods. Otherwise no screenshots are created.");
            return Collections.emptyList();
        }
        if (((MethodContext)methodContext.get()).readSessionContexts().count() == 0L) {
            LOGGER.warn("Could not create screenshots: No sessions found in current test context.");
            return Collections.emptyList();
        }
        Stream<List<Object>> screenshotStream = ((MethodContext)methodContext.get()).readSessionContexts().map(WebDriverSessionsManager::getWebDriver).filter(Optional::isPresent).map(Optional::get).map(UITestUtils::pTakeAllScreenshotsForSession).flatMap(Collection::stream);
        if (publishToReport) {
            screenshotStream = screenshotStream.peek(screenshot -> {
                ((MethodContext)methodContext.get()).addScreenshot(screenshot);
                report.addScreenshot(screenshot, Report.FileMode.MOVE);
            });
        }
        if ((result = screenshotStream.collect(Collectors.toList())).isEmpty()) {
            LOGGER.warn("Could not create screenshots of existing sessions.");
        }
        return result;
    }

    private static Screenshot takeScreenshot(WebDriver eventFiringWebDriver, String originalWindowHandle) {
        Screenshot screenshot = new Screenshot();
        UITestUtils.takeScreenshot(eventFiringWebDriver, screenshot);
        if (StringUtils.isNotBlank((CharSequence)originalWindowHandle)) {
            String windowHandle = eventFiringWebDriver.getWindowHandle();
            if (windowHandle.equals(originalWindowHandle)) {
                screenshot.getMetaData().put("Driver Focus", "true");
            } else {
                screenshot.getMetaData().put("Driver Focus", "false");
            }
        }
        return screenshot;
    }

    public static void takeWebDriverScreenshotToFile(WebDriver eventFiringWebDriver, File screenShotTargetFile) {
        WebDriver driver = eventFiringWebDriver instanceof EventFiringWebDriver ? ((EventFiringWebDriver)eventFiringWebDriver).getWrappedDriver() : eventFiringWebDriver;
        if ("ie".equalsIgnoreCase(WEB_DRIVER_MANAGER.getRequestedBrowser(eventFiringWebDriver).orElse(null))) {
            Rectangle viewport = new JSUtils().getViewport(driver);
            if (viewport.height > 1200) {
                LOGGER.warn("IE: Not taking screenshot because screen size is larger than height limit of 1200");
                return;
            }
        }
        UITestUtils.makeSimpleScreenshot(driver, screenShotTargetFile);
    }

    private static void makeSimpleScreenshot(WebDriver driver, File screenShotTargetFile) {
        try {
            File file = (File)((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
            FileUtils.moveFile((File)file, (File)screenShotTargetFile);
        }
        catch (Exception e) {
            LOGGER.error("Unable to take screenshot to file", (Throwable)e);
        }
    }

    private static void savePageSource(String pageSource, File sourceTargetFile) {
        try {
            FileOutputStream fos = new FileOutputStream(sourceTargetFile);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            outputStreamWriter.write(pageSource);
            outputStreamWriter.close();
        }
        catch (FileNotFoundException ex) {
            LoggerFactory.getLogger(UITestUtils.class).warn("PageSource file could not be written to file system: " + ex.toString());
        }
        catch (IOException ioe) {
            LoggerFactory.getLogger(UITestUtils.class).warn(ioe.toString());
        }
    }

    private static boolean switchToWindow(WebDriver webDriver, String windowHandle) {
        try {
            webDriver.switchTo().window(windowHandle);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Unable to switch to window " + windowHandle, (Throwable)e);
            return false;
        }
    }

    private static List<Screenshot> pTakeAllScreenshotsForSession(WebDriver webDriver) {
        LinkedList<Screenshot> screenshots = new LinkedList<Screenshot>();
        executionUtils.getFailsafe(() -> ((WebDriver)webDriver).getWindowHandles()).ifPresentOrElse(windowHandles -> {
            String originalWindowHandle = executionUtils.getFailsafe(() -> ((WebDriver)webDriver).getWindowHandle()).orElseGet(() -> windowHandles.stream().findFirst().orElse(""));
            if (windowHandles.size() > 1) {
                for (String windowHandle : windowHandles) {
                    UITestUtils.takeScreenshotToList(screenshots, webDriver, windowHandle, originalWindowHandle);
                }
                UITestUtils.switchToWindow(webDriver, originalWindowHandle);
            } else {
                UITestUtils.takeScreenshotToList(screenshots, webDriver, originalWindowHandle, originalWindowHandle);
            }
        }, () -> {
            try {
                Screenshot screenshot = UITestUtils.takeScreenshot(webDriver, "");
                screenshots.add(screenshot);
            }
            catch (Throwable t) {
                LOGGER.error("Unable to take screenshot", t);
            }
        });
        return screenshots;
    }

    private static void takeScreenshotToList(List<Screenshot> screenshots, WebDriver webDriver, String windowHandle, String originalWindowHandle) {
        if (UITestUtils.switchToWindow(webDriver, windowHandle)) {
            try {
                Screenshot screenshot = UITestUtils.takeScreenshot(webDriver, originalWindowHandle);
                screenshots.add(screenshot);
            }
            catch (Throwable t) {
                LOGGER.error("Unable to take screenshot", t);
            }
        }
    }

    public static void initializePerfTest() {
        if (Testerra.Properties.PERF_TEST.asBool().booleanValue()) {
            Properties fileProperties = PropertyManager.getFileProperties();
            String value = fileProperties.getProperty("tt.wdm.closewindows.aftertestmethods", "false");
            fileProperties.setProperty("tt.wdm.closewindows.aftertestmethods", value);
        }
    }
}

