/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.utils;

import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.utils.Timer;
import eu.tsystems.mms.tic.testframework.utils.WebDriverUtils;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverManagerUtils;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverSessionsManager;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openqa.selenium.WebDriver;

public class WebDriverKeepAliveSequence
extends Timer.Sequence<KeepAliveState>
implements Loggable {
    private static CopyOnWriteArrayList<WebDriverKeepAliveSequence> currentKeepAliveSessions = new CopyOnWriteArrayList();
    static final int GLOBAL_KEEP_ALIVE_TIMEOUT_IN_SECONDS = 3600;
    private boolean remove = false;
    private boolean forceRemove = false;
    private final WebDriver driver;

    WebDriverKeepAliveSequence() {
        this.driver = null;
    }

    WebDriverKeepAliveSequence(WebDriver driver) {
        this.driver = driver;
        WebDriverSessionsManager.registerWebDriverAfterShutdownHandler(webDriver -> {
            if (driver == webDriver) {
                this.forceRemove = true;
            }
        });
        currentKeepAliveSessions.add(this);
        this.log().info(String.format("Initialized a WebDriverKeepAliveSequence for driver with session id %s and session key %s.", WebDriverUtils.getSessionId(this.driver), WebDriverManagerUtils.getSessionKey(this.driver)));
    }

    void removeKeepAliveForDriver(WebDriver driver) {
        currentKeepAliveSessions.stream().filter(webDriverKeepAliveSequence -> webDriverKeepAliveSequence.driver == driver).findAny().ifPresent(webDriverKeepAliveSequence -> {
            webDriverKeepAliveSequence.remove = true;
        });
    }

    public void run() {
        if (this.remove) {
            this.setPassState(true);
            this.setReturningObject((Object)KeepAliveState.REMOVED_BY_USER);
            this.log().info("WebDriverKeepAliveSequence canceled by user.");
            currentKeepAliveSessions.remove((Object)this);
            return;
        }
        if (this.forceRemove) {
            this.setPassState(true);
            this.setReturningObject((Object)KeepAliveState.REMOVED_BY_DRIVER_SHUTDOWN);
            this.log().info("WebDriverKeepAliveSequence canceled because driver shut down.");
            currentKeepAliveSessions.remove((Object)this);
            return;
        }
        this.driver.getTitle();
        this.setPassState(false);
        this.setReturningObject((Object)KeepAliveState.REMOVED_BY_TIMEOUT);
    }

    public static enum KeepAliveState {
        REMOVED_BY_USER,
        REMOVED_BY_TIMEOUT,
        REMOVED_BY_DRIVER_SHUTDOWN;

    }
}

