/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.utils;

import eu.tsystems.mms.tic.testframework.common.PropertyManager;
import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.exceptions.SystemException;
import eu.tsystems.mms.tic.testframework.transfer.ThrowablePackedResponse;
import eu.tsystems.mms.tic.testframework.utils.ExecutionUtils;
import eu.tsystems.mms.tic.testframework.utils.JSUtils;
import eu.tsystems.mms.tic.testframework.utils.Timer;
import eu.tsystems.mms.tic.testframework.utils.WebDriverKeepAliveSequence;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverManager;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebDriverUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverUtils.class);
    private static final ExecutionUtils executionUtils = (ExecutionUtils)Testerra.getInjector().getInstance(ExecutionUtils.class);
    private static final long WINDOW_SWITCH_MAX_DURATION_TIME_SECONDS = PropertyManager.getLongProperty((String)"tt.wdm.timeouts.seconds.window.switch.duration", (long)3L);

    private WebDriverUtils() {
    }

    public static boolean switchToWindow(Predicate<WebDriver> predicate) {
        return WebDriverUtils.switchToWindow(WebDriverManager.getWebDriver(), predicate);
    }

    public static boolean switchToWindow(WebDriver mainWebDriver, Predicate<WebDriver> predicate) {
        String finalMainWindowHandle = executionUtils.getFailsafe(() -> ((WebDriver)mainWebDriver).getWindowHandle()).orElse("");
        return mainWebDriver.getWindowHandles().stream().map(windowHandle -> mainWebDriver.switchTo().window(windowHandle)).anyMatch(webDriver -> {
            boolean valid = predicate.test((WebDriver)webDriver);
            if (!valid && !finalMainWindowHandle.isEmpty()) {
                mainWebDriver.switchTo().window(finalMainWindowHandle);
            }
            return valid;
        });
    }

    public static boolean findWindowAndSwitchTo(String windowTitle) {
        return WebDriverUtils.findWindowAndSwitchTo(windowTitle, null, new String[0]);
    }

    public static boolean findWindowAndSwitchTo(String windowTitle, WebDriver driver, String ... excludeWindowHandles) {
        return WebDriverUtils.findWindowAndSwitchTo(windowTitle, null, driver, excludeWindowHandles);
    }

    public static boolean findWindowAndSwitchTo(final String windowTitle, final String urlContains, WebDriver driver, final String ... excludeWindowHandles) {
        if (driver == null) {
            driver = WebDriverManager.getWebDriver();
        }
        final WebDriver wdRef = driver;
        Timer timer = new Timer(500L, WINDOW_SWITCH_MAX_DURATION_TIME_SECONDS * 1000L);
        final String expectedCriteriaMsg = "\ntitle: " + windowTitle + "\nurl  : " + urlContains;
        ThrowablePackedResponse response = timer.executeSequence((Timer.Sequence)new Timer.Sequence<Boolean>(){

            public void run() {
                Set windowHandles = wdRef.getWindowHandles();
                LOGGER.info("Found " + windowHandles.size() + " opened windows");
                this.setPassState(false);
                this.setReturningObject(false);
                for (String windowHandle : windowHandles) {
                    boolean skip = false;
                    if (excludeWindowHandles != null) {
                        for (String excludeHandle : excludeWindowHandles) {
                            if (!excludeHandle.equals(windowHandle)) continue;
                            skip = true;
                            break;
                        }
                    }
                    if (!skip) {
                        boolean matchesUrl;
                        WebDriver window = wdRef.switchTo().window(windowHandle);
                        String realTitle = window.getTitle();
                        String url = window.getCurrentUrl();
                        boolean matchesTitle = windowTitle == null;
                        boolean bl = matchesUrl = urlContains == null;
                        if (windowTitle != null) {
                            matchesTitle = realTitle.contains(windowTitle);
                        }
                        if (urlContains != null) {
                            matchesUrl = url.contains(urlContains);
                        }
                        if (matchesTitle && matchesUrl) {
                            this.setPassState(true);
                            this.setReturningObject(true);
                            continue;
                        }
                        LOGGER.debug("Window title -" + realTitle + "- does not match" + expectedCriteriaMsg);
                        continue;
                    }
                    LOGGER.debug("Skipping window handle " + windowHandle);
                }
            }
        });
        return (Boolean)response.getResponse();
    }

    public static WebElement findElementByLocation(WebDriver driver, int x, int y) {
        Object out = JSUtils.executeScript(driver, "return document.elementFromPoint(" + x + "," + y + ");", new Object[0]);
        if (out != null) {
            LOGGER.debug("Element from coordinates " + x + "," + y + " : " + out);
            if (out instanceof WebElement) {
                WebElement webElement = (WebElement)out;
                LOGGER.debug("WebElement at " + x + "," + y + " is found at " + webElement.getLocation().getX() + "," + webElement.getLocation().getY());
                return webElement;
            }
            throw new SystemException("Could not get WebElement under " + x + "," + y);
        }
        return null;
    }

    static String getCookieString(WebDriver driver) {
        Object cookieString = "";
        Set cookieSet = driver.manage().getCookies();
        for (Cookie cookie : cookieSet) {
            cookieString = (String)cookieString + String.format("%s=%s;", cookie.getName(), cookie.getValue());
        }
        if (((String)cookieString).length() > 0) {
            cookieString = StringUtils.removeEnd((String)cookieString, (String)";");
        }
        return cookieString;
    }

    static void deleteAllCookies(WebDriver driver) {
        driver.manage().deleteAllCookies();
    }

    public static WebDriver getLowestWebDriver(WebDriver driver) {
        InvocationHandler invocationHandler;
        if (driver instanceof EventFiringWebDriver) {
            EventFiringWebDriver efWd = (EventFiringWebDriver)driver;
            driver = efWd.getWrappedDriver();
        }
        if (driver instanceof Proxy && (invocationHandler = Proxy.getInvocationHandler(driver)) instanceof WebDriverProxy) {
            WebDriverProxy webDriverProxy = (WebDriverProxy)((Object)invocationHandler);
            driver = webDriverProxy.getWrappedWebDriver();
        }
        return driver;
    }

    public static String getSessionId(WebDriver driver) {
        if ((driver = WebDriverUtils.getLowestWebDriver(driver)) instanceof RemoteWebDriver) {
            RemoteWebDriver remoteWebDriver = (RemoteWebDriver)driver;
            return remoteWebDriver.getSessionId().toString();
        }
        return null;
    }

    public static Rectangle getViewport(WebDriver webDriver) {
        return new JSUtils().getViewport(webDriver);
    }

    public static WebDriverKeepAliveSequence keepWebDriverAlive(WebDriver driver, int intervalSleepTimeInSeconds, int durationInSeconds) {
        if (durationInSeconds > 3600) {
            LOGGER.warn(String.format("Your duration %s is higher than the global duration. We will set your duration to %s to avoid abuse.", durationInSeconds, 3600));
            durationInSeconds = 3600;
        }
        WebDriverKeepAliveSequence webDriverKeepAliveSequence = new WebDriverKeepAliveSequence(driver);
        new Timer((long)(intervalSleepTimeInSeconds * 1000), (long)(durationInSeconds * 1000)).executeSequenceThread((Timer.Sequence)webDriverKeepAliveSequence);
        return webDriverKeepAliveSequence;
    }

    public static void removeKeepAliveForWebDriver(WebDriver driver) {
        new WebDriverKeepAliveSequence().removeKeepAliveForDriver(driver);
    }
}

