/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.watchdog;

import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.events.ExecutionAbortEvent;
import eu.tsystems.mms.tic.testframework.utils.SecUtils;
import eu.tsystems.mms.tic.testframework.webdrivermanager.TimingConstants;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebDriverWatchDog {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverWatchDog.class);
    private static final Map<String, Integer> ACTIVE_FORWARDS = new HashMap<String, Integer>();
    private static final WatchDogThread WATCH_DOG_THREAD = new WatchDogThread(new WatchDogRunnable());
    private static boolean started = false;

    public static void start() {
        if (started) {
            return;
        }
        started = true;
        LOGGER.debug("Starting...");
        WATCH_DOG_THREAD.start();
    }

    public static void stop() {
        if (!started) {
            return;
        }
        try {
            LOGGER.debug("Stopping...");
            WATCH_DOG_THREAD.stopWatchDog();
            LOGGER.debug("Stopped");
        }
        catch (InterruptedException e) {
            LOGGER.error("Unable to stop", (Throwable)e);
        }
        started = false;
    }

    private static class WatchDogRunnable
    implements Runnable {
        private boolean stop = false;

        private WatchDogRunnable() {
        }

        private void stop() throws InterruptedException {
            this.stop = true;
        }

        private boolean isStop() {
            return this.stop;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.info("Started");
            while (!this.isStop()) {
                Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
                ArrayList<CallSite> actualThreads = new ArrayList<CallSite>();
                for (Thread thread : allStackTraces.keySet()) {
                    StackTraceElement stackTraceElement;
                    StackTraceElement[] stackTrace;
                    String name = thread.getName();
                    if (name == null || !name.startsWith("Forwarding") || (stackTrace = thread.getStackTrace()) == null || stackTrace.length <= 0 || !(stackTraceElement = stackTrace[0]).toString().contains("java.net.SocketInputStream.socketRead0")) continue;
                    long threadId = thread.getId();
                    Object readableStacktrace = "";
                    for (StackTraceElement traceElement : stackTrace) {
                        readableStacktrace = (String)readableStacktrace + traceElement.toString() + "\n";
                    }
                    String stackTraceFingerprint = SecUtils.hash((String)readableStacktrace);
                    String key = "Thread " + threadId + ": " + name + " (" + stackTraceFingerprint + ")";
                    actualThreads.add((CallSite)((Object)key));
                    int newCount = 1;
                    if (ACTIVE_FORWARDS.containsKey(key)) {
                        newCount = ACTIVE_FORWARDS.get(key) + 1;
                    }
                    ACTIVE_FORWARDS.put(key, newCount);
                    int passedSeconds = newCount * 10;
                    if (passedSeconds > TimingConstants.WATCHDOG_FIRST_ANNOUNCEMENT_SECONDS) {
                        LOGGER.warn("(" + passedSeconds + "/" + TimingConstants.WEBDRIVER_COMMAND_TIMEOUT_SECONDS + " s) hanging a while now: " + key);
                    }
                    if (passedSeconds <= TimingConstants.WATCHDOG_THREAD_HANGING_TIMEOUT_SECONDS) continue;
                    LOGGER.error("Hung thread, awaiting safe stop: " + key);
                    if (passedSeconds <= TimingConstants.WATCHDOG_FORCE_QUIT_TIMEOUT_SECONDS) continue;
                    try {
                        Testerra.getEventBus().post((Object)new ExecutionAbortEvent());
                    }
                    finally {
                        System.err.println("Causing stacktrace on thread " + threadId + ":\n" + (String)readableStacktrace);
                        System.err.println("\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\nSTUCK SELENIUM COMMAND: " + key + "\n\nNo chance to recover from that. \n\nThe reason could be a stuck basic auth window, have a look at the browser!\nThe browser windows used are still open.\n\nExiting without parachute, system.exit..............................\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n");
                        System.exit(99);
                    }
                }
                ArrayList<String> toRemove = new ArrayList<String>();
                for (String key : ACTIVE_FORWARDS.keySet()) {
                    if (actualThreads.contains(key)) continue;
                    toRemove.add(key);
                }
                for (String key : toRemove) {
                    LOGGER.debug("Session gone: " + key);
                    ACTIVE_FORWARDS.remove(key);
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.error("Interrupted", (Throwable)interruptedException);
                }
            }
        }
    }

    private static class WatchDogThread
    extends Thread {
        private boolean stop = false;
        private final WatchDogRunnable watchDogRunnable;

        public WatchDogThread(WatchDogRunnable target) {
            super(target);
            this.watchDogRunnable = target;
        }

        private void stopWatchDog() throws InterruptedException {
            this.watchDogRunnable.stop();
            this.stop = true;
        }

        public boolean isStop() {
            return this.stop;
        }
    }
}

