/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.webdrivermanager;

import eu.tsystems.mms.tic.testframework.common.PropertyManager;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverRequest;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.DesiredCapabilities;

public class AbstractWebDriverRequest
implements WebDriverRequest,
Loggable {
    private String sessionKey = "default";
    private URL serverUrl;
    private DesiredCapabilities desiredCapabilities;
    private boolean shutdownAfterTest = false;
    private boolean shutdownAfterTestFailed = false;
    private boolean shutdownAfterExecution = true;
    private String browserName;

    public AbstractWebDriverRequest() {
        this.setShutdownAfterTest(PropertyManager.getBooleanProperty((String)"tt.wdm.closewindows.aftertestmethods", (boolean)true));
        this.setShutdownAfterTestFailed(PropertyManager.getBooleanProperty((String)"tt.wdm.closewindows.onfailure", (boolean)true));
        if (PropertyManager.getBooleanProperty((String)"tt.on.state.testfailed.skip.shutdown", (boolean)false)) {
            this.setShutdownAfterTestFailed(false);
        }
    }

    public String getBrowser() {
        return this.browserName;
    }

    public void setBrowser(String browser) {
        this.browserName = browser;
    }

    public String getBrowserVersion() {
        return this.getDesiredCapabilities().getVersion();
    }

    public void setBrowserVersion(String browserVersion) {
        this.getDesiredCapabilities().setVersion(browserVersion);
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setShutdownAfterTest(boolean shutdownAfterTest) {
        this.shutdownAfterTest = shutdownAfterTest;
    }

    public void setShutdownAfterTestFailed(boolean shutdownAfterTestFailed) {
        this.shutdownAfterTestFailed = shutdownAfterTestFailed;
    }

    public void setShutdownAfterExecution(boolean shutdownAfterExecution) {
        this.shutdownAfterExecution = shutdownAfterExecution;
    }

    public Optional<URL> getServerUrl() {
        return Optional.ofNullable(this.serverUrl);
    }

    public void setServerUrl(String url) throws MalformedURLException {
        this.setServerUrl(new URL(url));
    }

    public void setServerUrl(URL url) {
        this.serverUrl = url;
    }

    public void setSeleniumServerUrl(URL url) {
        this.setServerUrl(url);
    }

    public void setSeleniumServerUrl(String url) throws MalformedURLException {
        this.setServerUrl(url);
    }

    public boolean getShutdownAfterTest() {
        return this.shutdownAfterTest;
    }

    public boolean getShutdownAfterTestFailed() {
        return this.shutdownAfterTestFailed;
    }

    public boolean getShutdownAfterExecution() {
        return this.shutdownAfterExecution;
    }

    public Map<String, Object> getCapabilities() {
        return this.getDesiredCapabilities().asMap();
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public DesiredCapabilities getDesiredCapabilities() {
        if (this.desiredCapabilities == null) {
            this.desiredCapabilities = new DesiredCapabilities();
        }
        return this.desiredCapabilities;
    }

    public AbstractWebDriverRequest clone() throws CloneNotSupportedException {
        AbstractWebDriverRequest clone = (AbstractWebDriverRequest)super.clone();
        if (this.desiredCapabilities != null) {
            clone.desiredCapabilities = new DesiredCapabilities();
            clone.desiredCapabilities.merge((Capabilities)this.desiredCapabilities);
        }
        return clone;
    }

    public void setPlatformName(String platformName) {
        try {
            if (StringUtils.isNotBlank((CharSequence)platformName)) {
                Platform platform = Platform.fromString((String)platformName);
                this.getDesiredCapabilities().setCapability("platformName", platform);
            }
        }
        catch (WebDriverException e) {
            this.log().warn("Trying to set invalid platform '{}' was ignored.", (Object)platformName);
        }
    }

    public Optional<String> getPlatformName() {
        if (this.getDesiredCapabilities().getPlatform() != null) {
            return Optional.ofNullable(this.getDesiredCapabilities().getPlatform().toString());
        }
        return Optional.empty();
    }
}

