/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.webdrivermanager;

import eu.tsystems.mms.tic.testframework.common.IProperties;
import eu.tsystems.mms.tic.testframework.common.PropertyManagerProvider;
import eu.tsystems.mms.tic.testframework.enums.Position;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.webdrivermanager.SeleniumWebDriverRequest;
import eu.tsystems.mms.tic.testframework.webdrivermanager.desktop.WebDriverMode;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Dimension;

public class DesktopWebDriverRequest
extends SeleniumWebDriverRequest
implements Loggable,
Serializable,
PropertyManagerProvider {
    private static final int DEFAULT_WINDOW_SIZE_X = 1920;
    private static final int DEFAULT_WINDOW_SIZE_Y = 1080;
    private boolean maximize = PROPERTY_MANAGER.getBooleanProperty((IProperties)Properties.BROWSER_MAXIMIZE, Properties.BROWSER_MAXIMIZE.getDefault());
    private Position maximizePosition = Position.valueOf((String)PROPERTY_MANAGER.getProperty((IProperties)Properties.BROWSER_MAXIMIZE_POSITION, Properties.BROWSER_MAXIMIZE_POSITION.getDefault()).toUpperCase());
    private Dimension dimension = this.readDimensionFromString(Properties.WINDOW_SIZE.asString());

    public WebDriverMode getWebDriverMode() {
        return null;
    }

    public void setWebDriverMode(WebDriverMode webDriverMode) {
    }

    public void setMaximizeBrowser(boolean maximize) {
        this.maximize = maximize;
    }

    public boolean getMaximizeBrowser() {
        return this.maximize;
    }

    public void setMaximizePosition(Position position) {
        this.maximizePosition = position;
    }

    public Position getMaximizePosition() {
        return this.maximizePosition;
    }

    public Dimension getWindowSize() {
        return this.dimension;
    }

    public void setWindowSize(Dimension dimension) {
        this.dimension = dimension;
    }

    private Dimension readDimensionFromString(String windowSizeProperty) {
        Dimension dimension = new Dimension(1920, 1080);
        if (StringUtils.isNotBlank((CharSequence)windowSizeProperty)) {
            Pattern pattern = Pattern.compile("(\\d+)x(\\d+)");
            Matcher matcher = pattern.matcher(windowSizeProperty);
            if (matcher.find()) {
                int width = Integer.parseInt(matcher.group(1));
                int height = Integer.parseInt(matcher.group(2));
                dimension = new Dimension(width, height);
            } else {
                this.log().error(String.format("Unable to parse property %s=%s, falling back to default: %s", new Object[]{Properties.WINDOW_SIZE, windowSizeProperty, dimension}));
            }
        }
        return dimension;
    }

    public static enum Properties implements IProperties
    {
        BROWSER_MAXIMIZE("tt.browser.maximize", false),
        BROWSER_MAXIMIZE_POSITION("tt.browser.maximize.position", Position.CENTER.toString()),
        DISPLAY_RESOLUTION("tt.display.resolution", String.format("%sx%s", 1920, 1080)),
        WINDOW_SIZE("tt.window.size", DISPLAY_RESOLUTION.asString());

        private final String property;
        private final Object defaultValue;

        private Properties(String property, Object defaultValue) {
            this.property = property;
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return this.property;
        }

        public Object getDefault() {
            return this.defaultValue;
        }
    }
}

