/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.webdrivermanager;

import eu.tsystems.mms.tic.testframework.common.IProperties;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.report.model.context.SessionContext;
import eu.tsystems.mms.tic.testframework.useragents.UserAgentConfig;
import eu.tsystems.mms.tic.testframework.utils.WebDriverUtils;
import eu.tsystems.mms.tic.testframework.webdriver.WebDriverFactory;
import eu.tsystems.mms.tic.testframework.webdriver.WebDriverRetainer;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverManager;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverManagerConfig;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverRequest;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverSessionsManager;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;

public interface IWebDriverManager
extends WebDriverRetainer,
Loggable {
    @Override
    default public WebDriver getWebDriver() {
        return WebDriverManager.getWebDriver();
    }

    default public Optional<UserAgentConfig> getUserAgentConfig(String browser) {
        return Optional.ofNullable(WebDriverManager.getUserAgentConfig(browser));
    }

    default public String makeExclusive(WebDriver webDriver) {
        return WebDriverManager.makeSessionExclusive(webDriver);
    }

    default public WebDriverFactory getWebDriverFactoryForBrowser(String browser) {
        return WebDriverSessionsManager.getWebDriverFactory(browser);
    }

    default public void shutdownSession(String sessionKey) {
        WebDriverSessionsManager.shutdownSessionKey(sessionKey);
    }

    default public void shutdownSession(WebDriver webDriver) {
        WebDriverSessionsManager.shutdownWebDriver(webDriver);
    }

    default public void requestShutdownAllSessions() {
        WebDriverSessionsManager.WEBDRIVER_SESSIONS_CONTEXTS_MAP.forEach((webDriver, sessionContext) -> {
            if (sessionContext.getWebDriverRequest().getShutdownAfterExecution()) {
                WebDriverSessionsManager.shutdownWebDriver((WebDriver)webDriver);
            }
        });
    }

    default public void shutdownAllThreadSessions() {
        WebDriverManager.forceShutdown();
    }

    default public void shutdownAllSessions() {
        WebDriverManager.forceShutdownAllThreads();
    }

    default public EventFiringWebDriver getWebDriver(String sessionKey) {
        return WebDriverManager.getWebDriver(sessionKey);
    }

    default public EventFiringWebDriver getWebDriver(WebDriverRequest request) {
        return WebDriverManager.getWebDriver(request);
    }

    default public Optional<SessionContext> getSessionContext(WebDriver webDriver) {
        return WebDriverSessionsManager.getSessionContext(webDriver);
    }

    default public Optional<EventFiringWebDriver> getWebDriver(SessionContext sessionContext) {
        return WebDriverSessionsManager.getWebDriver(sessionContext);
    }

    default public Optional<String> getRequestedBrowser(WebDriver webDriver) {
        return WebDriverSessionsManager.getRequestedBrowser(webDriver);
    }

    default public String getSessionKey(WebDriver webDriver) {
        return WebDriverManager.getSessionKeyFrom(webDriver);
    }

    @Deprecated
    default public WebDriverManagerConfig getConfig() {
        return WebDriverManager.getConfig();
    }

    default public Stream<EventFiringWebDriver> readWebDriversFromCurrentThread() {
        return WebDriverSessionsManager.getWebDriversFromCurrentThread();
    }

    default public Stream<EventFiringWebDriver> readExclusiveWebDrivers() {
        return WebDriverSessionsManager.readExclusiveWebDrivers();
    }

    default public Stream<EventFiringWebDriver> readWebDrivers() {
        return WebDriverSessionsManager.readWebDrivers();
    }

    default public IWebDriverManager setUserAgentConfig(String browser, UserAgentConfig configurator) {
        WebDriverManager.setUserAgentConfig(browser, configurator);
        return this;
    }

    default public void registerWebDriverBeforeShutdownHandler(Consumer<WebDriver> beforeQuit) {
        WebDriverSessionsManager.registerWebDriverBeforeShutdownHandler(beforeQuit);
    }

    default public void registerWebDriverAfterShutdownHandler(Consumer<WebDriver> afterQuit) {
        WebDriverSessionsManager.registerWebDriverAfterShutdownHandler(afterQuit);
    }

    default public void registerWebDriverAfterStartupHandler(Consumer<WebDriver> afterStart) {
        WebDriverSessionsManager.registerWebDriverAfterStartupHandler(afterStart);
    }

    default public void registerWebDriverRequestConfigurator(Consumer<WebDriverRequest> handler) {
        WebDriverSessionsManager.webDriverRequestConfigurators.add(handler);
    }

    default public boolean switchToWindow(Predicate<WebDriver> predicate) {
        return WebDriverUtils.switchToWindow(this.getWebDriver(), predicate);
    }

    default public boolean switchToWindowTitle(String windowTitle) {
        return this.switchToWindowTitle(this.getWebDriver(), windowTitle);
    }

    default public boolean switchToWindow(WebDriver mainWebDriver, Predicate<WebDriver> predicate) {
        return WebDriverUtils.switchToWindow(mainWebDriver, predicate);
    }

    default public boolean switchToWindowTitle(WebDriver mainWebDriver, String windowTitle) {
        boolean switched = WebDriverUtils.switchToWindow(mainWebDriver, webDriver -> webDriver.getTitle().equals(windowTitle));
        if (!switched) {
            throw new RuntimeException(String.format("Window title \"%s\" not found", windowTitle));
        }
        return switched;
    }

    default public boolean switchToWindowHandle(WebDriver mainWebDriver, String windowHandle) {
        boolean switched = WebDriverUtils.switchToWindow(mainWebDriver, webDriver -> webDriver.getWindowHandle().equals(windowHandle));
        if (!switched) {
            throw new RuntimeException(String.format("Window handle \"%s\" not found", windowHandle));
        }
        return switched;
    }

    default public void keepAlive(WebDriver webDriver, int intervalSleepTimeInSeconds, int durationInSeconds) {
        WebDriverUtils.keepWebDriverAlive(webDriver, intervalSleepTimeInSeconds, durationInSeconds);
    }

    default public void stopKeepingAlive(WebDriver webDriver) {
        WebDriverUtils.removeKeepAliveForWebDriver(webDriver);
    }

    default public void setGlobalCapability(String key, Object value) {
        WebDriverManager.setGlobalExtraCapability(key, value);
    }

    default public void removeGlobalCapability(String key) {
        WebDriverManager.removeGlobalExtraCapability(key);
    }

    default public <WEBDRIVER> Optional<WEBDRIVER> unwrapWebDriver(WebDriver webDriver, Class<WEBDRIVER> targetWebDriverClass) {
        WebDriver lowestWebDriver = WebDriverUtils.getLowestWebDriver(webDriver);
        if (targetWebDriverClass.isInstance(lowestWebDriver)) {
            return Optional.of(lowestWebDriver);
        }
        return Optional.empty();
    }

    default public boolean setSessionLocale(WebDriver webDriver, Locale locale) {
        return WebDriverManager.setSessionLocale(webDriver, locale);
    }

    default public Optional<Locale> getSessionLocale(WebDriver webDriver) {
        return WebDriverManager.getSessionLocale(webDriver);
    }

    public static enum Properties implements IProperties
    {
        BROWSER("tt.browser", ""),
        BROWSER_VERSION("tt.browser.version", ""),
        BROWSER_SETTING("tt.browser.setting", ""),
        BROWSER_PLATFORM("tt.browser.platform", null);

        private final String property;
        private final Object defaultValue;

        private Properties(String property, Object defaultValue) {
            this.property = property;
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return this.property;
        }

        public Object getDefault() {
            return this.defaultValue;
        }
    }
}

