/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.webdrivermanager;

import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.webdrivermanager.AbstractWebDriverRequest;
import eu.tsystems.mms.tic.testframework.webdrivermanager.IWebDriverManager;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SeleniumWebDriverRequest
extends AbstractWebDriverRequest
implements Serializable {
    private URL baseUrl = null;

    public SeleniumWebDriverRequest() {
        String baseUrl;
        String browserSetting = IWebDriverManager.Properties.BROWSER_SETTING.asString();
        if (StringUtils.isNotBlank((CharSequence)browserSetting)) {
            String[] split = browserSetting.split(":");
            if (split.length > 0) {
                this.setBrowser(split[0].trim());
            }
            if (split.length > 1) {
                this.setBrowserVersion(split[1].trim());
            }
            if (split.length > 2) {
                this.setPlatformName(split[2].trim());
            }
        }
        if (StringUtils.isBlank((CharSequence)this.getBrowser())) {
            this.setBrowser(IWebDriverManager.Properties.BROWSER.asString());
        }
        if (StringUtils.isBlank((CharSequence)this.getBrowserVersion())) {
            this.setBrowserVersion(IWebDriverManager.Properties.BROWSER_VERSION.asString());
        }
        if (!this.getPlatformName().isPresent()) {
            this.setPlatformName(IWebDriverManager.Properties.BROWSER_PLATFORM.asString());
        }
        if (!(baseUrl = Testerra.Properties.BASEURL.asString()).isEmpty()) {
            try {
                this.setBaseUrl(baseUrl);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Unable to read base url from property " + Testerra.Properties.BASEURL, e);
            }
        }
    }

    public Optional<URL> getBaseUrl() {
        return Optional.ofNullable(this.baseUrl);
    }

    public SeleniumWebDriverRequest setBaseUrl(String baseUrl) throws MalformedURLException {
        this.baseUrl = new URL(baseUrl);
        return this;
    }

    public SeleniumWebDriverRequest setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Override
    public Optional<URL> getServerUrl() {
        if (!super.getServerUrl().isPresent()) {
            String serverHost;
            String serverUrl = Testerra.Properties.SELENIUM_SERVER_URL.asString();
            if (StringUtils.isBlank((CharSequence)serverUrl) && StringUtils.isNotBlank((CharSequence)(serverHost = Testerra.Properties.SELENIUM_SERVER_HOST.asString()))) {
                serverUrl = String.format("http://%s:%d/wd/hub", serverHost, Testerra.Properties.SELENIUM_SERVER_PORT.asLong());
            }
            if (StringUtils.isNotBlank((CharSequence)serverUrl)) {
                try {
                    this.setServerUrl(serverUrl);
                }
                catch (MalformedURLException e) {
                    this.log().error("Unable to retrieve default Selenium URL from properties", (Throwable)e);
                }
            }
        }
        return super.getServerUrl();
    }
}

