/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.webdrivermanager;

import eu.tsystems.mms.tic.testframework.common.PropertyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimingConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimingConstants.class);
    public static final int WATCHDOG_THREAD_POLL_INTERVAL_SECONDS = 10;
    public static final int WEBDRIVER_COMMAND_TIMEOUT_SECONDS = PropertyManager.getIntProperty((String)"tt.watchdog.timeout.seconds", (int)360);
    public static final int WATCHDOG_FIRST_ANNOUNCEMENT_SECONDS;
    public static final int WATCHDOG_THREAD_HANGING_TIMEOUT_SECONDS;
    public static final int WATCHDOG_FORCE_QUIT_TIMEOUT_SECONDS;

    private TimingConstants() {
    }

    static {
        if (WEBDRIVER_COMMAND_TIMEOUT_SECONDS < 120) {
            String msg = "\n\nWatchDog timeout to low: " + WEBDRIVER_COMMAND_TIMEOUT_SECONDS + " Set at least to 2 minutes.\n\n";
            System.err.println(msg);
            throw new RuntimeException(msg);
        }
        WATCHDOG_FIRST_ANNOUNCEMENT_SECONDS = WEBDRIVER_COMMAND_TIMEOUT_SECONDS / 2;
        WATCHDOG_THREAD_HANGING_TIMEOUT_SECONDS = WEBDRIVER_COMMAND_TIMEOUT_SECONDS - 20;
        WATCHDOG_FORCE_QUIT_TIMEOUT_SECONDS = WEBDRIVER_COMMAND_TIMEOUT_SECONDS + 60;
        LOGGER.info("WatchDog Timings:\n FlagUp:    " + WATCHDOG_THREAD_HANGING_TIMEOUT_SECONDS + "s\n SelfStop:  " + WEBDRIVER_COMMAND_TIMEOUT_SECONDS + "s\n ForceQuit: " + WATCHDOG_FORCE_QUIT_TIMEOUT_SECONDS + "s");
    }
}

