/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.webdrivermanager;

import eu.tsystems.mms.tic.testframework.utils.CertUtils;
import eu.tsystems.mms.tic.testframework.webdrivermanager.AbstractWebDriverRequest;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverCapabilities
implements Consumer<WebDriverRequest> {
    protected static final Map<String, Object> GLOBALCAPABILITIES = new HashMap<String, Object>();
    protected static final Logger LOGGER = LoggerFactory.getLogger(WebDriverCapabilities.class);

    static void addGlobalCapability(String key, Object value) {
        if ("browserName".equals(key)) {
            LOGGER.warn("Skipping extra desired capability " + key);
            return;
        }
        GLOBALCAPABILITIES.put(key, value);
    }

    static void removeGlobalExtraCapability(String key) {
        GLOBALCAPABILITIES.remove(key);
    }

    static void clearGlobalCapabilities() {
        GLOBALCAPABILITIES.clear();
    }

    static void setGlobalExtraCapabilities(DesiredCapabilities desiredCapabilities) {
        Map map = desiredCapabilities.asMap();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            WebDriverCapabilities.addGlobalCapability(key, value);
        }
    }

    static Map<String, Object> getGlobalExtraCapabilities() {
        return GLOBALCAPABILITIES;
    }

    @Override
    public void accept(WebDriverRequest webDriverRequest) {
        if (webDriverRequest instanceof AbstractWebDriverRequest) {
            DesiredCapabilities desiredCapabilities = ((AbstractWebDriverRequest)webDriverRequest).getDesiredCapabilities();
            desiredCapabilities.merge((Capabilities)new DesiredCapabilities(GLOBALCAPABILITIES));
            CertUtils certUtils = CertUtils.getInstance();
            if (certUtils.isTrustAllHosts() || certUtils.getTrustedHosts().length > 0) {
                desiredCapabilities.setAcceptInsecureCerts(true);
            }
        }
    }
}

