/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.webdrivermanager;

import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.exceptions.SystemException;
import eu.tsystems.mms.tic.testframework.internal.utils.DriverStorage;
import eu.tsystems.mms.tic.testframework.report.model.context.AbstractContext;
import eu.tsystems.mms.tic.testframework.report.utils.ExecutionContextUtils;
import eu.tsystems.mms.tic.testframework.useragents.UserAgentConfig;
import eu.tsystems.mms.tic.testframework.utils.UITestUtils;
import eu.tsystems.mms.tic.testframework.webdriver.WebDriverFactory;
import eu.tsystems.mms.tic.testframework.webdrivermanager.UnspecificWebDriverRequest;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WDInternal;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverCapabilities;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverManagerConfig;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverRequest;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverSessionsManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class WebDriverManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverManager.class);
    public static final String DEFAULT_SESSION_KEY = "default";
    @Deprecated
    private static WebDriverManagerConfig webdriverManagerConfig;
    private static final HashMap<String, UserAgentConfig> userAgentConfigurators;
    private static final String SESSION_LOCALE = "locale";

    WebDriverManager() {
    }

    public static void setGlobalExtraCapability(String key, Object value) {
        WebDriverManager.addGlobalCapability(key, value);
    }

    @Deprecated
    public static void setGlobalExtraCapabilities(DesiredCapabilities desiredCapabilities) {
        WebDriverCapabilities.setGlobalExtraCapabilities(desiredCapabilities);
    }

    public static Map<String, Object> getGlobalExtraCapabilities() {
        return WebDriverCapabilities.getGlobalExtraCapabilities();
    }

    private static void addGlobalCapability(String key, Object value) {
        WebDriverCapabilities.addGlobalCapability(key, value);
    }

    public static void removeGlobalExtraCapability(String key) {
        WebDriverCapabilities.removeGlobalExtraCapability(key);
    }

    public static WebDriver getWebDriver() {
        return WebDriverManager.getWebDriver(DEFAULT_SESSION_KEY);
    }

    public static EventFiringWebDriver getWebDriver(String sessionKey) {
        UnspecificWebDriverRequest webDriverRequest = new UnspecificWebDriverRequest();
        webDriverRequest.setSessionKey(sessionKey);
        return WebDriverManager.getWebDriver(webDriverRequest);
    }

    public static EventFiringWebDriver getWebDriver(WebDriverRequest webDriverRequest) {
        return WebDriverSessionsManager.getWebDriver(webDriverRequest);
    }

    public static void introduceWebDriver(WebDriver driver) {
        WebDriverManager.introduceWebDriver(DEFAULT_SESSION_KEY, driver);
    }

    public static void introduceWebDriver(String sessionKey, WebDriver driver) {
        WebDriverSessionsManager.introduceWebDriver(sessionKey, driver);
    }

    protected static Boolean isWebDriverActive() {
        return WebDriverSessionsManager.hasAnySessionActive();
    }

    public static void forceShutdown() {
        WebDriverSessionsManager.shutdownAllThreadSessions();
        if (Testerra.Properties.REUSE_DATAPROVIDER_DRIVER_BY_THREAD.asBool().booleanValue()) {
            String testMethodName = ExecutionContextUtils.getMethodNameFromCurrentTestResult();
            DriverStorage.removeSpecificDriver(testMethodName);
        }
    }

    public static void shutdown() {
        WebDriverManager.forceShutdown();
    }

    @Deprecated
    public static WebDriverManagerConfig config() {
        if (webdriverManagerConfig == null) {
            webdriverManagerConfig = new WebDriverManagerConfig();
        }
        return webdriverManagerConfig;
    }

    @Deprecated
    public static WebDriverManagerConfig getConfig() {
        return WebDriverManager.config();
    }

    public static boolean isJavaScriptActivated(WebDriver driver) {
        return WebDriverManager.pIsJavaScriptActivated(driver);
    }

    private static boolean pIsJavaScriptActivated(WebDriver driver) {
        if (!(driver instanceof JavascriptExecutor)) {
            throw new SystemException("WebDriver object is not a JavascriptExecutor");
        }
        JavascriptExecutor rawJsExecutorDriver = (JavascriptExecutor)driver;
        try {
            rawJsExecutorDriver.executeScript("return true;", new Object[0]);
        }
        catch (WebDriverException e) {
            return false;
        }
        return true;
    }

    public static boolean hasAnySessionActive() {
        return WebDriverSessionsManager.hasAnySessionActive();
    }

    public static boolean hasSessionsActiveInThisThread() {
        return WebDriverSessionsManager.hasSessionActiveInThisThread();
    }

    @Deprecated
    public static void forceShutdownAllThreads() {
        LOGGER.info("Forcing all WebDrivers to shutdown (close all windows)");
        WebDriverSessionsManager.shutdownAllSessions();
        WDInternal.cleanupDriverReferencesInCurrentThread();
    }

    public static String makeSessionExclusive(WebDriver driver) {
        return WebDriverSessionsManager.makeSessionExclusive(driver);
    }

    public static void shutdownExclusiveSession(String key) {
        WebDriverSessionsManager.shutdownSessionKey(key);
    }

    public static Stream<EventFiringWebDriver> getWebDriversFromThread(long threadId) {
        return WebDriverSessionsManager.getWebDriversFromThread(threadId);
    }

    @Deprecated
    public static void registerWebDriverFactory(WebDriverFactory webDriverFactory, String ... browsers) {
        WebDriverSessionsManager.registerWebDriverFactory(webDriverFactory, browsers);
    }

    public static String getSessionKeyFrom(WebDriver driver) {
        return WebDriverSessionsManager.getSessionKey(driver);
    }

    public static void setUserAgentConfig(String browser, UserAgentConfig configurator) {
        userAgentConfigurators.put(browser, configurator);
    }

    static UserAgentConfig getUserAgentConfig(String browser) {
        return userAgentConfigurators.get(browser);
    }

    public static boolean setSessionLocale(WebDriver webDriver, Locale locale) {
        Optional<Map> optionalMetaData = WebDriverSessionsManager.getSessionContext(webDriver).map(AbstractContext::getMetaData);
        optionalMetaData.ifPresent(map -> map.put(SESSION_LOCALE, locale));
        return optionalMetaData.isPresent();
    }

    public static Optional<Locale> getSessionLocale(WebDriver webDriver) {
        return WebDriverSessionsManager.getSessionContext(webDriver).map(AbstractContext::getMetaData).map(map -> (Locale)map.get(SESSION_LOCALE));
    }

    static {
        UITestUtils.initializePerfTest();
        userAgentConfigurators = new HashMap();
    }
}

