/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.webdrivermanager;

import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.useragents.BrowserInformation;
import eu.tsystems.mms.tic.testframework.webdrivermanager.ProvidesBrowserInformation;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverSessionsManager;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebDriverManagerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverManagerUtils.class);

    private WebDriverManagerUtils() {
    }

    public static BrowserInformation getBrowserInformation(WebDriver driver) {
        BrowserInformation browserInformation;
        if (driver == null) {
            return null;
        }
        WebDriver realDriver = driver;
        if (EventFiringWebDriver.class.isAssignableFrom(driver.getClass())) {
            realDriver = ((EventFiringWebDriver)driver).getWrappedDriver();
        }
        if (ProvidesBrowserInformation.class.isAssignableFrom(realDriver.getClass())) {
            browserInformation = ((ProvidesBrowserInformation)realDriver).getBrowserInformation();
        } else if (JavascriptExecutor.class.isAssignableFrom(realDriver.getClass())) {
            String userAgentString = "unknown";
            try {
                userAgentString = (String)((JavascriptExecutor)realDriver).executeScript("return navigator.userAgent;", new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Error requesting user agent", (Throwable)e);
            }
            browserInformation = (BrowserInformation)Testerra.getInjector().getInstance(BrowserInformation.class);
            browserInformation.parseUserAgent(userAgentString);
        } else {
            browserInformation = (BrowserInformation)Testerra.getInjector().getInstance(BrowserInformation.class);
        }
        return browserInformation;
    }

    protected static void quitWebDriverSession(WebDriver driver) {
        try {
            driver.quit();
        }
        catch (Throwable e) {
            LOGGER.warn("WebDriver could not be quit. May someone did before.", e);
        }
    }

    public static String getSessionKey(WebDriver driver) {
        return WebDriverSessionsManager.getSessionKey(driver);
    }
}

