/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.webdrivermanager;

import eu.tsystems.mms.tic.testframework.common.PropertyManager;
import eu.tsystems.mms.tic.testframework.utils.ProxyUtils;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Proxy;

public class WebDriverProxyUtils {
    private String toProxyString(URL proxyUrl) {
        Object proxyString = null;
        if (proxyUrl != null && StringUtils.isNotBlank((CharSequence)proxyUrl.getHost())) {
            proxyString = proxyUrl.getHost();
            if (proxyUrl.getPort() > -1) {
                proxyString = (String)proxyString + ":" + proxyUrl.getPort();
            }
        }
        return proxyString;
    }

    public Proxy createSocksProxyFromUrl(URL url) {
        Proxy proxy = this.createHttpProxyFromUrl(url);
        proxy.setSocksProxy(proxy.getHttpProxy());
        String userInfo = url.getUserInfo();
        if (userInfo != null && userInfo.length() > 0) {
            String[] userInfoParts = userInfo.split(":", 2);
            if (userInfoParts.length > 0) {
                proxy.setSocksUsername(userInfoParts[0]);
            }
            if (userInfoParts.length > 1) {
                proxy.setSocksPassword(userInfoParts[1]);
            }
        }
        return proxy;
    }

    public Proxy createHttpProxyFromUrl(URL url) {
        String proxyString = this.toProxyString(url);
        Proxy proxy = new Proxy();
        proxy.setHttpProxy(proxyString);
        proxy.setSslProxy(proxyString);
        return proxy;
    }

    public Proxy getDefaultSocksProxy() {
        Proxy proxy = this.createSocksProxyFromUrl(ProxyUtils.getSystemHttpsProxyUrl());
        proxy.setNoProxy(PropertyManager.getProperty((String)"https.nonProxyHosts"));
        return proxy;
    }

    public Proxy getDefaultHttpProxy() {
        URL systemProxyUrl = ProxyUtils.getSystemHttpsProxyUrl();
        if (systemProxyUrl == null) {
            systemProxyUrl = ProxyUtils.getSystemHttpProxyUrl();
        }
        Proxy proxy = this.createHttpProxyFromUrl(systemProxyUrl);
        proxy.setNoProxy(PropertyManager.getProperty((String)"https.nonProxyHosts"));
        return proxy;
    }
}

