/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.webdrivermanager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.events.ContextUpdateEvent;
import eu.tsystems.mms.tic.testframework.exceptions.SystemException;
import eu.tsystems.mms.tic.testframework.internal.utils.DriverStorage;
import eu.tsystems.mms.tic.testframework.report.model.context.AbstractContext;
import eu.tsystems.mms.tic.testframework.report.model.context.SessionContext;
import eu.tsystems.mms.tic.testframework.report.utils.ExecutionContextUtils;
import eu.tsystems.mms.tic.testframework.report.utils.IExecutionContextController;
import eu.tsystems.mms.tic.testframework.useragents.BrowserInformation;
import eu.tsystems.mms.tic.testframework.utils.DefaultCapabilityUtils;
import eu.tsystems.mms.tic.testframework.utils.ObjectUtils;
import eu.tsystems.mms.tic.testframework.webdriver.WebDriverFactory;
import eu.tsystems.mms.tic.testframework.webdrivermanager.IWebDriverManager;
import eu.tsystems.mms.tic.testframework.webdrivermanager.UnspecificWebDriverRequest;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverManagerUtils;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverProxy;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverRequest;
import java.lang.reflect.InvocationHandler;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class WebDriverSessionsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverSessionsManager.class);
    private static final Map<String, WebDriverFactory> WEB_DRIVER_FACTORIES = new HashMap<String, WebDriverFactory>();
    public static final Map<Date, Throwable> SESSION_STARTUP_ERRORS = new LinkedHashMap<Date, Throwable>();
    private static final Map<String, EventFiringWebDriver> EXCLUSIVE_SESSION_KEY_WEBDRIVER_MAP = new ConcurrentHashMap<String, EventFiringWebDriver>();
    private static final Map<String, EventFiringWebDriver> THREAD_SESSION_KEY_WEBDRIVER_MAP = new ConcurrentHashMap<String, EventFiringWebDriver>();
    private static final Map<EventFiringWebDriver, Long> WEBDRIVER_THREAD_ID_MAP = new ConcurrentHashMap<EventFiringWebDriver, Long>();
    static final Map<EventFiringWebDriver, SessionContext> WEBDRIVER_SESSIONS_CONTEXTS_MAP = new ConcurrentHashMap<EventFiringWebDriver, SessionContext>();
    private static final Queue<Consumer<WebDriver>> beforeQuitActions = new ConcurrentLinkedQueue<Consumer<WebDriver>>();
    private static final Queue<Consumer<WebDriver>> afterQuitActions = new ConcurrentLinkedQueue<Consumer<WebDriver>>();
    private static final Queue<Consumer<WebDriver>> WEBDRIVER_STARTUP_HANDLERS = new ConcurrentLinkedQueue<Consumer<WebDriver>>();
    private static final String FULL_SESSION_KEY_SPLIT_MARKER = "___";
    private static final Set<WebDriverFactory> webDriverFactories = (Set)Testerra.getInjector().getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<WebDriverFactory>>(){}));
    static final Queue<Consumer<WebDriverRequest>> webDriverRequestConfigurators = new ConcurrentLinkedQueue<Consumer<WebDriverRequest>>();
    private static final IExecutionContextController executionContextController = (IExecutionContextController)Testerra.getInjector().getInstance(IExecutionContextController.class);

    private WebDriverSessionsManager() {
    }

    private static String getThreadSessionKey(String sessionKey) {
        Thread currentThread = Thread.currentThread();
        return currentThread.getId() + FULL_SESSION_KEY_SPLIT_MARKER + sessionKey;
    }

    private static void storeWebDriverSession(EventFiringWebDriver eventFiringWebDriver, SessionContext sessionContext) {
        WebDriverRequest webDriverRequest = sessionContext.getWebDriverRequest();
        String sessionKey = webDriverRequest.getSessionKey();
        String threadSessionKey = WebDriverSessionsManager.getThreadSessionKey(sessionKey);
        THREAD_SESSION_KEY_WEBDRIVER_MAP.put(threadSessionKey, eventFiringWebDriver);
        long threadId = Thread.currentThread().getId();
        WEBDRIVER_THREAD_ID_MAP.put(eventFiringWebDriver, threadId);
        if (Testerra.Properties.REUSE_DATAPROVIDER_DRIVER_BY_THREAD.asBool().booleanValue()) {
            String methodName = ExecutionContextUtils.getMethodNameFromCurrentTestResult();
            String threadName = "" + Thread.currentThread().getId();
            LOGGER.debug("Saving driver in " + DriverStorage.class.getSimpleName() + " for : " + methodName + ": " + threadName);
            DriverStorage.saveDriverForTestMethod((WebDriver)eventFiringWebDriver, threadName, methodName);
        }
        WEBDRIVER_SESSIONS_CONTEXTS_MAP.put(eventFiringWebDriver, sessionContext);
    }

    private static void unlinkFromThread(String sessionKey, EventFiringWebDriver eventFiringWebDriver) {
        String sessionIdentifier = WebDriverSessionsManager.createSessionIdentifier((WebDriver)eventFiringWebDriver, sessionKey);
        LOGGER.trace("Unlink from thread: " + sessionIdentifier);
        String threadSessionKey = WebDriverSessionsManager.getThreadSessionKey(sessionKey);
        THREAD_SESSION_KEY_WEBDRIVER_MAP.remove(threadSessionKey, eventFiringWebDriver);
        long threadId = Thread.currentThread().getId();
        WEBDRIVER_THREAD_ID_MAP.remove(eventFiringWebDriver, threadId);
        executionContextController.clearCurrentSessionContext();
        if (Testerra.Properties.REUSE_DATAPROVIDER_DRIVER_BY_THREAD.asBool().booleanValue()) {
            String methodName = ExecutionContextUtils.getMethodNameFromCurrentTestResult();
            String threadName = "" + Thread.currentThread().getId();
            LOGGER.info("Removing driver in " + DriverStorage.class.getSimpleName() + " for : " + methodName + ": " + threadName);
            DriverStorage.removeSpecificDriver(methodName);
        }
        String msg = "Removed WebDriver session: " + sessionKey;
        msg = msg + "\n Remaining sessions: ";
        int i = 0;
        for (WebDriver webDriver : WEBDRIVER_THREAD_ID_MAP.keySet()) {
            Long tid = WEBDRIVER_THREAD_ID_MAP.get(webDriver);
            String key = WebDriverSessionsManager.getSessionKey(webDriver);
            msg = msg + "\n  " + key + " in thread " + tid;
            ++i;
        }
        msg = msg + "\n => " + i + " sessions (map: " + THREAD_SESSION_KEY_WEBDRIVER_MAP.size() + ")";
        LOGGER.debug(msg);
    }

    static void introduceWebDriver(String sessionKey, WebDriver webDriver) {
        if (!(webDriver instanceof RemoteWebDriver)) {
            throw new IllegalArgumentException("The driver object of the argument must be an instance of RemoteWebDriver");
        }
        LOGGER.info("Introducing webdriver object");
        UnspecificWebDriverRequest request = new UnspecificWebDriverRequest();
        request.setSessionKey(sessionKey);
        SessionContext sessionContext = new SessionContext((WebDriverRequest)request);
        EventFiringWebDriver eventFiringWebDriver = WebDriverSessionsManager.wrapWebDriver(webDriver, sessionContext);
        executionContextController.getCurrentMethodContext().ifPresent(methodContext -> {
            methodContext.addSessionContext(sessionContext);
            executionContextController.setCurrentSessionContext(sessionContext);
        });
        WebDriverSessionsManager.storeWebDriverSession(eventFiringWebDriver, sessionContext);
    }

    public static void registerWebDriverBeforeShutdownHandler(Consumer<WebDriver> beforeQuit) {
        beforeQuitActions.add(beforeQuit);
    }

    public static void registerWebDriverAfterShutdownHandler(Consumer<WebDriver> afterQuit) {
        afterQuitActions.add(afterQuit);
    }

    public static void registerWebDriverAfterStartupHandler(Consumer<WebDriver> afterStart) {
        WEBDRIVER_STARTUP_HANDLERS.add(afterStart);
    }

    public static void unregisterWebDriverAfterStartupHandler(Consumer<WebDriver> afterStart) {
        WEBDRIVER_STARTUP_HANDLERS.remove(afterStart);
    }

    private static String createSessionIdentifier(WebDriver webDriver, String sessionKey) {
        return String.format("%s (sessionKey=%s)", webDriver.getClass().getSimpleName(), sessionKey);
    }

    public static void shutdownWebDriver(WebDriver webDriver) {
        EventFiringWebDriver eventFiringWebDriver = WebDriverSessionsManager.checkForWrappedWebDriver(webDriver);
        String sessionKey = WebDriverSessionsManager.getSessionKey((WebDriver)eventFiringWebDriver);
        String sessionIdentifier = WebDriverSessionsManager.createSessionIdentifier((WebDriver)eventFiringWebDriver, sessionKey);
        beforeQuitActions.forEach(webDriverConsumer -> {
            try {
                LOGGER.trace("Call before shutdown handler");
                webDriverConsumer.accept(eventFiringWebDriver);
            }
            catch (Exception e) {
                LOGGER.error("Failed executing before shutdown handler", (Throwable)e);
            }
        });
        LOGGER.info("Shutting down " + sessionIdentifier);
        WebDriverManagerUtils.quitWebDriverSession((WebDriver)eventFiringWebDriver);
        afterQuitActions.forEach(webDriverConsumer -> {
            try {
                LOGGER.trace("Call after shutdown handler");
                webDriverConsumer.accept(eventFiringWebDriver);
            }
            catch (Exception e) {
                LOGGER.error("Failed executing after shutdown handler", (Throwable)e);
            }
        });
        WebDriverSessionsManager.unlinkFromThread(sessionKey, eventFiringWebDriver);
        WEBDRIVER_SESSIONS_CONTEXTS_MAP.remove(eventFiringWebDriver);
        if (sessionKey.startsWith("EXCLUSIVE_")) {
            EXCLUSIVE_SESSION_KEY_WEBDRIVER_MAP.remove(sessionKey);
        }
        LOGGER.debug("Shut down: " + sessionIdentifier);
    }

    static void shutdownAllThreadSessions() {
        WebDriverSessionsManager.getWebDriversFromCurrentThread().forEach(WebDriverSessionsManager::shutdownWebDriver);
    }

    public static Stream<EventFiringWebDriver> getWebDriversFromCurrentThread() {
        long threadId = Thread.currentThread().getId();
        return WebDriverSessionsManager.getWebDriversFromThread(threadId);
    }

    public static Stream<EventFiringWebDriver> readExclusiveWebDrivers() {
        return EXCLUSIVE_SESSION_KEY_WEBDRIVER_MAP.values().stream();
    }

    static void shutdownAllSessions() {
        THREAD_SESSION_KEY_WEBDRIVER_MAP.values().forEach(WebDriverSessionsManager::shutdownWebDriver);
        EXCLUSIVE_SESSION_KEY_WEBDRIVER_MAP.values().forEach(WebDriverSessionsManager::shutdownWebDriver);
    }

    static boolean hasAnySessionActive() {
        return WebDriverSessionsManager.hasSessionActiveInThisThread();
    }

    static boolean hasSessionActiveInThisThread() {
        long threadId = Thread.currentThread().getId();
        return WebDriverSessionsManager.getWebDriversFromThread(threadId).findAny().isPresent();
    }

    static synchronized String makeSessionExclusive(WebDriver webDriver) {
        EventFiringWebDriver eventFiringWebDriver = WebDriverSessionsManager.checkForWrappedWebDriver(webDriver);
        if (EXCLUSIVE_SESSION_KEY_WEBDRIVER_MAP.containsValue(eventFiringWebDriver)) {
            LOGGER.error("Session already set exclusive.");
            return null;
        }
        SessionContext sessionContext = WebDriverSessionsManager.getSessionContext((WebDriver)eventFiringWebDriver).get();
        String sessionKey = sessionContext.getSessionKey();
        WebDriverSessionsManager.unlinkFromThread(sessionKey, eventFiringWebDriver);
        String exclusiveSessionKey = "EXCLUSIVE_" + UUID.randomUUID().toString();
        EXCLUSIVE_SESSION_KEY_WEBDRIVER_MAP.put(exclusiveSessionKey, eventFiringWebDriver);
        sessionContext.setSessionKey(exclusiveSessionKey);
        sessionContext.getWebDriverRequest().setShutdownAfterTest(false);
        sessionContext.getWebDriverRequest().setShutdownAfterTestFailed(false);
        executionContextController.getExecutionContext().addExclusiveSessionContext(sessionContext);
        Testerra.getEventBus().post((Object)new ContextUpdateEvent().setContext((AbstractContext)sessionContext));
        LOGGER.info("Promoted " + WebDriverSessionsManager.createSessionIdentifier(webDriver, sessionKey) + " to " + WebDriverSessionsManager.createSessionIdentifier(webDriver, exclusiveSessionKey));
        return exclusiveSessionKey;
    }

    public static void shutdownSessionKey(String key) {
        if (EXCLUSIVE_SESSION_KEY_WEBDRIVER_MAP.containsKey(key)) {
            WebDriverSessionsManager.shutdownWebDriver((WebDriver)EXCLUSIVE_SESSION_KEY_WEBDRIVER_MAP.get(key));
            EXCLUSIVE_SESSION_KEY_WEBDRIVER_MAP.remove(key);
        } else if (THREAD_SESSION_KEY_WEBDRIVER_MAP.containsKey(key)) {
            WebDriverSessionsManager.shutdownWebDriver((WebDriver)THREAD_SESSION_KEY_WEBDRIVER_MAP.get(key));
        }
    }

    static String getSessionKey(WebDriver webDriver) {
        return WebDriverSessionsManager.getSessionContext(webDriver).map(SessionContext::getSessionKey).orElse("no session");
    }

    static Stream<EventFiringWebDriver> getWebDriversFromThread(long threadId) {
        return WEBDRIVER_THREAD_ID_MAP.entrySet().stream().filter(entry -> (Long)entry.getValue() == threadId).map(Map.Entry::getKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventFiringWebDriver getWebDriver(WebDriverRequest webDriverRequest) {
        String sessionKey = webDriverRequest.getSessionKey();
        EventFiringWebDriver existingWebDriver = null;
        if (sessionKey.startsWith("EXCLUSIVE_")) {
            if (!EXCLUSIVE_SESSION_KEY_WEBDRIVER_MAP.containsKey(sessionKey)) throw new SystemException("No Session for key: " + sessionKey);
            existingWebDriver = EXCLUSIVE_SESSION_KEY_WEBDRIVER_MAP.get(sessionKey);
        } else {
            String fullSessionKey = WebDriverSessionsManager.getThreadSessionKey(sessionKey);
            existingWebDriver = THREAD_SESSION_KEY_WEBDRIVER_MAP.get(fullSessionKey);
        }
        if (existingWebDriver != null) {
            if (sessionKey.startsWith("EXCLUSIVE_")) {
                executionContextController.getExecutionContext().readExclusiveSessionContexts().filter(sessionContext -> sessionContext.getSessionKey().equals(sessionKey)).findFirst().ifPresent(sessionContext -> executionContextController.getCurrentMethodContext().ifPresent(currentMethodContext -> currentMethodContext.addSessionContext(sessionContext)));
                return existingWebDriver;
            } else {
                executionContextController.getCurrentSessionContext().ifPresent(currentSessionContext -> executionContextController.getCurrentMethodContext().ifPresent(currentMethodContext -> currentMethodContext.addSessionContext(currentSessionContext)));
            }
            return existingWebDriver;
        }
        String browser = webDriverRequest.getBrowser();
        if (StringUtils.isBlank((CharSequence)browser)) {
            throw new SystemException(String.format("No browser configured. Please define one in %s.setBrowser() or property '%s'", new Object[]{WebDriverRequest.class.getSimpleName(), IWebDriverManager.Properties.BROWSER_SETTING}));
        }
        if (!WEB_DRIVER_FACTORIES.containsKey(browser)) throw new SystemException(String.format("No %s registered for browser '%s'", WebDriverFactory.class.getSimpleName(), browser));
        WebDriverFactory webDriverFactory = WEB_DRIVER_FACTORIES.get(browser);
        WebDriverRequest finalWebDriverRequest = webDriverFactory.prepareWebDriverRequest(webDriverRequest);
        webDriverRequestConfigurators.forEach(handler -> handler.accept(finalWebDriverRequest));
        SessionContext sessionContext2 = new SessionContext(finalWebDriverRequest);
        executionContextController.getCurrentMethodContext().ifPresent(methodContext -> methodContext.addSessionContext(sessionContext2));
        executionContextController.setCurrentSessionContext(sessionContext2);
        WebDriverSessionsManager.logRequest(finalWebDriverRequest, sessionContext2);
        StopWatch sw = new StopWatch();
        sw.start();
        WebDriver newRawWebDriver = webDriverFactory.createWebDriver(finalWebDriverRequest, sessionContext2);
        sw.stop();
        if (!sessionContext2.getActualBrowserName().isPresent()) {
            BrowserInformation browserInformation = WebDriverManagerUtils.getBrowserInformation(newRawWebDriver);
            sessionContext2.setActualBrowserName(browserInformation.getBrowserName());
            sessionContext2.setActualBrowserVersion(browserInformation.getBrowserVersion());
        }
        if (newRawWebDriver instanceof RemoteWebDriver) {
            SessionId sessionId = ((RemoteWebDriver)newRawWebDriver).getSessionId();
            sessionContext2.setRemoteSessionId(sessionId.toString());
        } else {
            sessionContext2.setRemoteSessionId(sessionContext2.getId());
        }
        LOGGER.info(String.format("Started %s (sessionKey=%s, node=%s, userAgent=%s) in %s", newRawWebDriver.getClass().getSimpleName(), sessionContext2.getSessionKey(), sessionContext2.getNodeUrl().map(Object::toString).orElse("(unknown)"), sessionContext2.getActualBrowserName().orElse("(unknown)") + ":" + sessionContext2.getActualBrowserVersion().orElse("(unknown)"), sw));
        EventFiringWebDriver eventFiringWebDriver = WebDriverSessionsManager.wrapWebDriver(newRawWebDriver, sessionContext2);
        WebDriverSessionsManager.storeWebDriverSession(eventFiringWebDriver, sessionContext2);
        webDriverFactory.setupNewWebDriverSession(eventFiringWebDriver, sessionContext2);
        Testerra.getEventBus().post((Object)new ContextUpdateEvent().setContext((AbstractContext)sessionContext2));
        String sessionIdentifier = WebDriverSessionsManager.createSessionIdentifier(newRawWebDriver, sessionKey);
        WEBDRIVER_STARTUP_HANDLERS.forEach(webDriverConsumer -> {
            try {
                webDriverConsumer.accept(eventFiringWebDriver);
            }
            catch (Exception e) {
                LOGGER.error("Failed executing handler after starting up " + sessionIdentifier, (Throwable)e);
            }
        });
        return eventFiringWebDriver;
    }

    private static void logRequest(WebDriverRequest request, SessionContext sessionContext) {
        Map<String, Object> cleanedCapsMap = new DefaultCapabilityUtils().clean(request.getCapabilities());
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        LOGGER.info(String.format("New %s (sessionKey=%s, server=%s) with capabilities:\n%s", request.getClass().getSimpleName(), sessionContext.getSessionKey(), request.getServerUrl().isPresent() ? request.getServerUrl().get() : "local", gson.toJson(cleanedCapsMap)));
        LOGGER.debug(String.format("Starting (sessionKey=%s) here", sessionContext.getSessionKey()), new Throwable());
    }

    @Deprecated
    static void registerWebDriverFactory(WebDriverFactory webDriverFactory, String ... browsers) {
        LOGGER.debug("Register " + webDriverFactory.getClass().getSimpleName() + " for browsers " + String.join((CharSequence)", ", browsers));
        for (String browser : browsers) {
            WEB_DRIVER_FACTORIES.put(browser, webDriverFactory);
        }
    }

    private static EventFiringWebDriver checkForWrappedWebDriver(WebDriver webDriver) {
        if (!(webDriver instanceof EventFiringWebDriver)) {
            throw new IllegalArgumentException(webDriver.getClass().getSimpleName() + " is no instance of " + EventFiringWebDriver.class.getSimpleName());
        }
        return (EventFiringWebDriver)webDriver;
    }

    public static boolean isExclusiveSession(WebDriver webDriver) {
        webDriver = WebDriverSessionsManager.checkForWrappedWebDriver(webDriver);
        return EXCLUSIVE_SESSION_KEY_WEBDRIVER_MAP.containsValue(webDriver);
    }

    public static Optional<SessionContext> getSessionContext(WebDriver webDriver) {
        webDriver = WebDriverSessionsManager.checkForWrappedWebDriver(webDriver);
        return Optional.ofNullable(WEBDRIVER_SESSIONS_CONTEXTS_MAP.get(webDriver));
    }

    public static Optional<EventFiringWebDriver> getWebDriver(SessionContext sessionContext) {
        return WEBDRIVER_SESSIONS_CONTEXTS_MAP.entrySet().stream().filter(entry -> entry.getValue() == sessionContext).map(Map.Entry::getKey).findFirst();
    }

    public static Optional<String> getRequestedBrowser(WebDriver webDriver) {
        return WebDriverSessionsManager.getSessionContext(webDriver).map(SessionContext::getWebDriverRequest).map(WebDriverRequest::getBrowser);
    }

    public static WebDriverFactory getWebDriverFactory(String browser) {
        if (WEB_DRIVER_FACTORIES.containsKey(browser)) {
            return WEB_DRIVER_FACTORIES.get(browser);
        }
        throw new RuntimeException("No " + WebDriverFactory.class.getSimpleName() + " registered for browser: " + browser);
    }

    public static Stream<SessionContext> readSessionContexts() {
        return WEBDRIVER_SESSIONS_CONTEXTS_MAP.values().stream();
    }

    public static Stream<EventFiringWebDriver> readWebDrivers() {
        return WEBDRIVER_SESSIONS_CONTEXTS_MAP.keySet().stream();
    }

    private static EventFiringWebDriver wrapWebDriver(WebDriver webDriver, SessionContext sessionContext) {
        try {
            WebDriverProxy webDriverProxy = new WebDriverProxy(webDriver, sessionContext);
            Class[] interfaces = ObjectUtils.getAllInterfacesOf((Object)webDriver);
            webDriver = (WebDriver)ObjectUtils.simpleProxy(WebDriver.class, (InvocationHandler)((Object)webDriverProxy), (Class[])interfaces);
        }
        catch (Exception e) {
            LOGGER.error("Could not create proxy for raw webdriver", (Throwable)e);
        }
        return new EventFiringWebDriver(webDriver);
    }

    static {
        webDriverFactories.stream().sorted(Comparator.comparing(f -> f.getClass().getSimpleName())).forEach(webDriverFactory -> webDriverFactory.getSupportedBrowsers().forEach(browser -> WEB_DRIVER_FACTORIES.put((String)browser, (WebDriverFactory)webDriverFactory)));
    }
}

