/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.webdrivermanager;

import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.utils.ObjectUtils;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverSessionsManager;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebElementProxy
extends ObjectUtils.PassThroughProxy<WebElement>
implements Loggable {
    private final WebDriver driver;

    public WebElementProxy(WebDriver driver, WebElement webElement) {
        super((Object)webElement);
        this.driver = driver;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        WebDriverSessionsManager.getSessionContext(this.driver).ifPresent(sessionContext -> {
            if (!method.getName().equals("toString")) {
                Object msg = method.getName();
                if (args != null) {
                    msg = (String)msg + " " + Arrays.stream(args).map(Object::toString).collect(Collectors.joining(" "));
                }
                this.log().trace((String)msg);
            }
        });
        return this.invoke(method, args);
    }
}

