/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.mailconnector.util;

import com.sun.mail.util.MailSSLSocketFactory;
import eu.tsystems.mms.tic.testframework.common.PropertyManager;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.utils.CertUtils;
import jakarta.mail.Authenticator;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import java.security.GeneralSecurityException;
import java.util.Properties;
import java.util.function.Consumer;

public abstract class AbstractMailConnector
implements Loggable {
    private String server;
    private String port;
    private String inboxFolder;
    private String username;
    private String password;
    private boolean debug;
    private boolean sslEnabled;
    private Session session;
    protected Consumer<Properties> sessionPropertiesConfigurationConsumer;

    protected abstract void openSession();

    public AbstractMailConnector() {
        PropertyManager.loadProperties((String)"mailconnection.properties");
    }

    public AbstractMailConnector configureSessionProperties(Consumer<Properties> consumer) {
        this.sessionPropertiesConfigurationConsumer = consumer;
        return this;
    }

    protected Session createDefaultSession(Properties mailProperties, String protocol) {
        mailProperties.put("mail." + protocol + ".host", this.getServer());
        mailProperties.put("mail." + protocol + ".port", this.getPort());
        try {
            MailSSLSocketFactory sf = new MailSSLSocketFactory();
            CertUtils certUtils = CertUtils.getInstance();
            if (certUtils.isTrustAllHosts()) {
                this.log().warn("Trusting all hosts");
                sf.setTrustAllHosts(true);
                mailProperties.put("mail." + protocol + ".ssl.trust", "*");
            } else {
                CharSequence[] hostsToTrust = certUtils.getTrustedHosts();
                if (hostsToTrust != null) {
                    String trustedHostsString = String.join((CharSequence)" ", hostsToTrust);
                    this.log().info("Trusting hosts: " + trustedHostsString);
                    mailProperties.put("mail." + protocol + ".ssl.trust", trustedHostsString);
                    sf.setTrustedHosts((String[])hostsToTrust);
                }
            }
            mailProperties.put("mail." + protocol + ".ssl.socketFactory", sf);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Error opening session", e);
        }
        mailProperties.put("mail.debug", (Object)this.isDebug());
        mailProperties.put("mail.debug.auth", (Object)this.isDebug());
        if (this.sessionPropertiesConfigurationConsumer != null) {
            this.sessionPropertiesConfigurationConsumer.accept(mailProperties);
        }
        this.log().info(String.format("Connecting to %s://%s@%s:%s", protocol, this.getUsername(), this.getServer(), this.getPort()));
        Session session = Session.getInstance((Properties)mailProperties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(AbstractMailConnector.this.getUsername(), AbstractMailConnector.this.getPassword());
            }
        });
        session.setDebug(this.isDebug());
        return session;
    }

    public Session getSession() {
        if (this.session == null) {
            this.openSession();
        }
        return this.session;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getInboxFolder() {
        return this.inboxFolder;
    }

    public void setInboxFolder(String inboxFolder) {
        this.inboxFolder = inboxFolder;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

