/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.listeners;

import com.google.common.eventbus.Subscribe;
import eu.tsystems.mms.tic.testframework.events.FinalizeExecutionEvent;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class CopyReportAppListener
implements FinalizeExecutionEvent.Listener,
Loggable {
    private File targetDir;

    public CopyReportAppListener(File targetDir) {
        this.targetDir = targetDir;
    }

    @Subscribe
    public void onFinalizeExecution(FinalizeExecutionEvent event) {
        try {
            for (Path resourcePath : this.getPathsFromResource("report-ng").collect(Collectors.toList())) {
                String stringRepresentationOfResourcePath = StringUtils.stripStart((String)resourcePath.toString(), (String)"/");
                InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(stringRepresentationOfResourcePath);
                try {
                    if (resourceStream == null) {
                        throw new Exception("Could not open stream: " + stringRepresentationOfResourcePath);
                    }
                    File targetFile = new File(this.targetDir, resourcePath.toString());
                    FileUtils.copyInputStreamToFile((InputStream)resourceStream, (File)targetFile);
                }
                finally {
                    if (resourceStream == null) continue;
                    resourceStream.close();
                }
            }
        }
        catch (Exception e) {
            this.log().error("Unable to copy app resource", (Throwable)e);
        }
    }

    private Stream<Path> getPathsFromResource(String folder) throws URISyntaxException, IOException {
        URI pathUri = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        try {
            URI uri = URI.create("jar:file:" + pathUri.getRawPath());
            FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
            Path resourceDirPath = fs.getPath(folder, new String[0]);
            return Files.walk(resourceDirPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
        }
        catch (IOException | ProviderNotFoundException e) {
            URL resourceUrl = this.getClass().getClassLoader().getResource(folder);
            this.log().warn(String.format("Unable to read from resource JAR: %s, trying local resources: %s", e.getMessage(), resourceUrl));
            Path resourceDirPath = Paths.get(resourceUrl.toURI());
            return Files.walk(resourceDirPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(resourceFilePath -> resourceDirPath.getParent().relativize((Path)resourceFilePath));
        }
    }
}

