/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.listeners;

import com.google.common.eventbus.Subscribe;
import com.google.protobuf.Message;
import eu.tsystems.mms.tic.testframework.adapters.ContextExporter;
import eu.tsystems.mms.tic.testframework.events.FinalizeExecutionEvent;
import eu.tsystems.mms.tic.testframework.listeners.AbstractReportModelListener;
import eu.tsystems.mms.tic.testframework.report.model.ExecutionAggregate;
import eu.tsystems.mms.tic.testframework.report.model.ExecutionContext;
import eu.tsystems.mms.tic.testframework.report.model.File;
import eu.tsystems.mms.tic.testframework.report.model.SessionContext;
import eu.tsystems.mms.tic.testframework.report.model.context.ExecutionContext;
import eu.tsystems.mms.tic.testframework.report.model.context.MethodContext;
import eu.tsystems.mms.tic.testframework.report.model.context.Screenshot;
import eu.tsystems.mms.tic.testframework.report.model.context.SessionContext;
import eu.tsystems.mms.tic.testframework.report.model.context.Video;
import java.io.File;
import java.util.Objects;
import java.util.stream.Stream;

public class GenerateReportNgModelListener
extends AbstractReportModelListener
implements FinalizeExecutionEvent.Listener {
    private final ExecutionAggregate.Builder executionAggregateBuilder = ExecutionAggregate.newBuilder();
    private final ContextExporter contextExporter = new ContextExporter(){

        public File.Builder buildVideo(Video video) {
            File.Builder builder = super.buildVideo(video);
            this.writeFileBuilderToFile(builder);
            return builder;
        }

        public File.Builder[] buildScreenshot(Screenshot screenshot) {
            File.Builder[] builders = super.buildScreenshot(screenshot);
            Stream.of(builders).filter(Objects::nonNull).forEach(this::writeFileBuilderToFile);
            return builders;
        }

        private void writeFileBuilderToFile(File.Builder fileBuilder) {
            GenerateReportNgModelListener.this.writeBuilderToFile((Message.Builder)fileBuilder, new File(GenerateReportNgModelListener.this.getFilesDir(), fileBuilder.getId()));
        }
    };

    public GenerateReportNgModelListener(File baseDir) {
        super(baseDir);
    }

    @Subscribe
    public void onFinalizeExecution(FinalizeExecutionEvent event) {
        ExecutionContext executionContext = event.getExecutionContext();
        executionContext.readSuiteContexts().forEach(suiteContext -> {
            this.executionAggregateBuilder.putSuiteContexts(suiteContext.getId(), this.contextExporter.buildSuiteContext(suiteContext).build());
            suiteContext.readTestContexts().forEach(testContext -> {
                this.executionAggregateBuilder.putTestContexts(testContext.getId(), this.contextExporter.buildTestContext(testContext).build());
                testContext.readClassContexts().forEach(classContext -> {
                    this.executionAggregateBuilder.putClassContexts(classContext.getId(), this.contextExporter.buildClassContext(classContext).build());
                    classContext.readMethodContexts().forEach(methodContext -> {
                        this.buildUniqueMethod((MethodContext)methodContext);
                        methodContext.readSessionContexts().forEach(this::buildUniqueSession);
                        methodContext.readRelatedMethodContexts().forEach(this::buildUniqueMethod);
                    });
                });
            });
        });
        executionContext.readExclusiveSessionContexts().forEach(this::buildUniqueSession);
        ExecutionContext.Builder executionContextBuilder = this.contextExporter.buildExecutionContext(executionContext);
        this.executionAggregateBuilder.setExecutionContext(executionContextBuilder);
        this.writeBuilderToFile((Message.Builder)this.executionAggregateBuilder, new File(this.baseDir, "execution"));
    }

    private void buildUniqueSession(SessionContext sessionContext) {
        if (!this.executionAggregateBuilder.containsSessionContexts(sessionContext.getId())) {
            SessionContext.Builder sessionContextBuilder = this.contextExporter.buildSessionContext(sessionContext);
            this.executionAggregateBuilder.putSessionContexts(sessionContext.getId(), sessionContextBuilder.build());
        }
    }

    private void buildUniqueMethod(MethodContext methodContext) {
        if (!this.executionAggregateBuilder.containsMethodContexts(methodContext.getId())) {
            this.executionAggregateBuilder.putMethodContexts(methodContext.getId(), this.contextExporter.buildMethodContext(methodContext).build());
        }
    }
}

