/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testerra.plugins.selenoid.collector;

import eu.tsystems.mms.tic.testerra.plugins.selenoid.request.VideoRequest;
import eu.tsystems.mms.tic.testerra.plugins.selenoid.request.VideoRequestStorage;
import eu.tsystems.mms.tic.testerra.plugins.selenoid.utils.SelenoidHelper;
import eu.tsystems.mms.tic.testerra.plugins.selenoid.utils.VideoLoader;
import eu.tsystems.mms.tic.testframework.common.PropertyManager;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.report.Status;
import eu.tsystems.mms.tic.testframework.report.model.context.ExecutionContext;
import eu.tsystems.mms.tic.testframework.report.model.context.SessionContext;
import eu.tsystems.mms.tic.testframework.report.model.context.Video;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverSessionsManager;
import java.util.Optional;
import java.util.function.Consumer;
import org.openqa.selenium.WebDriver;
import org.testng.ITestResult;

public class SelenoidEvidenceVideoCollector
implements Consumer<WebDriver>,
Loggable {
    private final SelenoidHelper selenoidHelper = SelenoidHelper.get();
    private final VideoRequestStorage videoRequestStorage = VideoRequestStorage.get();
    private final boolean SCREENCASTER_ACTIVE_ON_SUCCESS = PropertyManager.getBooleanProperty((String)"tt.screencaster.active.on.success", (boolean)false);
    private final boolean SCREENCASTER_ACTIVE_ON_FAILED = PropertyManager.getBooleanProperty((String)"tt.screencaster.active.on.failed", (boolean)true);

    @Override
    public void accept(WebDriver webDriver) {
        WebDriverSessionsManager.getSessionContext((WebDriver)webDriver).ifPresent(sessionContext -> {
            if (sessionContext.getParentContext() instanceof ExecutionContext) {
                this.collectVideoForSessionContext((SessionContext)sessionContext);
            } else if (sessionContext.readMethodContexts().anyMatch(methodContext -> {
                if (methodContext.getTestNgResult().isPresent()) {
                    ITestResult testResult = (ITestResult)methodContext.getTestNgResult().get();
                    if (!testResult.isSuccess() && this.SCREENCASTER_ACTIVE_ON_FAILED) {
                        return true;
                    }
                    if (this.SCREENCASTER_ACTIVE_ON_SUCCESS) {
                        return true;
                    }
                    if (testResult.getStatus() == 3 && methodContext.getStatus() == Status.RETRIED) {
                        return true;
                    }
                }
                return false;
            })) {
                this.collectVideoForSessionContext((SessionContext)sessionContext);
            }
        });
    }

    private Optional<Video> downloadLinkAndCleanVideo(VideoRequest videoRequest) {
        Video video = new VideoLoader().download(videoRequest);
        if (video != null) {
            videoRequest.sessionContext.setVideo(video);
            this.selenoidHelper.deleteRemoteVideoFile(videoRequest);
        } else {
            this.log().warn("Unable to download video");
        }
        return Optional.ofNullable(video);
    }

    protected void collectVideoForSessionContext(SessionContext sessionContext) {
        this.videoRequestStorage.list().stream().filter(videoRequest -> videoRequest.sessionContext == sessionContext).findFirst().ifPresent(videoRequest -> {
            this.downloadLinkAndCleanVideo((VideoRequest)videoRequest);
            this.videoRequestStorage.remove((VideoRequest)videoRequest);
        });
    }
}

