/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testerra.plugins.selenoid.hooks;

import com.google.inject.AbstractModule;
import eu.tsystems.mms.tic.testerra.plugins.selenoid.collector.SelenoidEvidenceVideoCollector;
import eu.tsystems.mms.tic.testerra.plugins.selenoid.webdriver.SelenoidCapabilityProvider;
import eu.tsystems.mms.tic.testerra.plugins.selenoid.webdriver.VideoDesktopWebDriverFactory;
import eu.tsystems.mms.tic.testframework.common.PropertyManager;
import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.hooks.ModuleHook;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.testing.WebDriverManagerProvider;
import java.util.function.Consumer;

public class SelenoidVideoHook
extends AbstractModule
implements ModuleHook,
Loggable,
WebDriverManagerProvider {
    private static final boolean VIDEO_ACTIVE = Testerra.Properties.SCREENCASTER_ACTIVE.asBool();
    private static final boolean VNC_ACTIVE = PropertyManager.getBooleanProperty((String)"tt.selenoid.vnc.enabled", (boolean)true);

    public void init() {
        if (!VIDEO_ACTIVE && !VNC_ACTIVE) {
            this.log().warn(String.format("Selenoid features disabled. Neither %s nor %s is set to true.", Testerra.Properties.SCREENCASTER_ACTIVE, "tt.selenoid.vnc.enabled"));
            return;
        }
        WEB_DRIVER_MANAGER.registerWebDriverRequestConfigurator((Consumer)new SelenoidCapabilityProvider());
        WEB_DRIVER_MANAGER.registerWebDriverAfterStartupHandler((Consumer)new VideoDesktopWebDriverFactory());
        if (VIDEO_ACTIVE) {
            WEB_DRIVER_MANAGER.registerWebDriverAfterShutdownHandler((Consumer)new SelenoidEvidenceVideoCollector());
        }
    }

    public void terminate() {
    }
}

