/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testerra.plugins.selenoid.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import eu.tsystems.mms.tic.testerra.plugins.selenoid.request.VideoRequest;
import eu.tsystems.mms.tic.testerra.plugins.selenoid.utils.SelenoidProperties;
import eu.tsystems.mms.tic.testerra.plugins.selenoid.utils.SelenoidRestClient;
import eu.tsystems.mms.tic.testframework.common.PropertyManager;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.model.NodeInfo;
import eu.tsystems.mms.tic.testframework.report.model.context.SessionContext;
import eu.tsystems.mms.tic.testframework.transfer.ThrowablePackedResponse;
import eu.tsystems.mms.tic.testframework.utils.FileDownloader;
import eu.tsystems.mms.tic.testframework.utils.Timer;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SelenoidHelper
implements Loggable {
    private static final String VNC_ADDRESS = PropertyManager.getProperty((String)"tt.selenoid.vnc.address", (String)SelenoidProperties.Default.VNC_ADDRESS);
    private static final SelenoidHelper INSTANCE = new SelenoidHelper();

    private SelenoidHelper() {
    }

    public boolean updateNodeInfo(URL seleniumUrl, String remoteSessionId, SessionContext sessionContext) {
        String url = seleniumUrl.toString();
        url = url.replace("/wd/hub", "");
        try {
            SelenoidRestClient client = new SelenoidRestClient(url);
            Optional<String> response = client.getHost(remoteSessionId);
            if (!response.isPresent()) {
                throw new Exception("There was no response from " + url);
            }
            String nodeResponse = response.get();
            if (StringUtils.isNotBlank((CharSequence)nodeResponse) && nodeResponse.toLowerCase().contains("selenoid")) {
                return true;
            }
            Gson gson = new GsonBuilder().create();
            Map map = (Map)gson.fromJson(nodeResponse, Map.class);
            double port = Double.parseDouble(map.get("Port").toString());
            String scheme = map.get("Scheme").toString();
            if (scheme.isEmpty()) {
                scheme = "http";
            }
            sessionContext.setNodeUrl(new URL(scheme, map.get("Name").toString(), (int)port, ""));
            return true;
        }
        catch (Exception e) {
            this.log().warn("It seems you are not using Selenoid - could not get node info: " + e.getMessage());
            return false;
        }
    }

    public static SelenoidHelper get() {
        return INSTANCE;
    }

    public boolean isSelenoidUsed(SessionContext sessionContext) {
        Optional<String> url = this.getSelenoidUrl(sessionContext.getNodeInfo());
        if (!url.isPresent()) {
            return false;
        }
        SelenoidRestClient client = new SelenoidRestClient(url.get());
        Optional<String> response = client.getPing();
        if (!response.isPresent()) {
            this.log().warn("Empty response from " + url.get());
            return false;
        }
        try {
            String ping = response.get();
            Gson gson = new Gson();
            Map result = (Map)gson.fromJson(ping, Map.class);
            if (result != null && result.containsKey("version")) {
                this.log().debug("Selenoid ping from " + url.get() + ": " + result);
                return true;
            }
            this.log().warn("No Selenoid response from " + url.get());
        }
        catch (JsonSyntaxException e) {
            this.log().warn("Error pinging selenoid", (Throwable)e);
        }
        return false;
    }

    public String getRemoteVncUrl(VideoRequest videoRequest, String sessionId) {
        String selenoidSessionId = this.getSelenoidSessionId(Optional.ofNullable(sessionId));
        return videoRequest.sessionContext.getNodeInfo().map(nodeInfo -> VNC_ADDRESS + "?host=" + nodeInfo.getHost() + "&port=" + nodeInfo.getPort() + "&path=vnc/" + selenoidSessionId + "&autoconnect=true&password=selenoid").orElse(null);
    }

    public void deleteRemoteVideoFile(VideoRequest videoRequest) {
        Optional<String> url = this.getSelenoidUrl(videoRequest.sessionContext.getNodeInfo());
        if (!url.isPresent()) {
            this.log().warn("Cannot delete Selenoid video because there is no host.");
        } else {
            SelenoidRestClient client = new SelenoidRestClient(url.get());
            Optional<String> response = client.deleteVideofile(videoRequest.selenoidVideoName);
            if (!response.isPresent()) {
                this.log().warn("Deleting remote video was not successful.");
            }
        }
    }

    public Optional<String> getVideoUrlString(VideoRequest videoRequest) {
        return videoRequest.sessionContext.getNodeInfo().map(nodeInfo -> "http://" + nodeInfo.getHost() + ":" + nodeInfo.getPort() + "/video/" + videoRequest.selenoidVideoName);
    }

    public String getRemoteVideoFile(VideoRequest videoRequest) {
        String videoName;
        Optional<String> optionalVideoUrlString = this.getVideoUrlString(videoRequest);
        if (!optionalVideoUrlString.isPresent()) {
            return null;
        }
        Timer timer = new Timer(5000L, 20000L);
        final FileDownloader downloader = new FileDownloader();
        final String videoUrlString = optionalVideoUrlString.get();
        ThrowablePackedResponse response = timer.executeSequence((Timer.Sequence)new Timer.Sequence<String>(videoName = "video_" + videoRequest.selenoidVideoName){
            final /* synthetic */ String val$videoName;
            {
                this.val$videoName = string2;
            }

            public void run() throws Throwable {
                this.setSkipThrowingException(true);
                this.setAddThrowableToMethodContext(false);
                String download = downloader.download(null, videoUrlString, this.val$videoName);
                this.setReturningObject(download);
            }
        });
        if (response.isSuccessful()) {
            return (String)response.getResponse();
        }
        return null;
    }

    public String getRemoteDownloadPath(SessionContext sessionContext, String filename) {
        String selenoidSessionId = this.getSelenoidSessionId(sessionContext.getRemoteSessionId());
        return sessionContext.getNodeInfo().map(nodeInfo -> String.format("http://%s:%s/download/%s/%s", nodeInfo.getHost(), nodeInfo.getPort(), selenoidSessionId, filename)).orElse(null);
    }

    public String getClipboard(SessionContext sessionContext) {
        String selenoidSessionId = this.getSelenoidSessionId(sessionContext.getRemoteSessionId());
        Optional<String> url = this.getSelenoidUrl(sessionContext.getNodeInfo());
        if (!url.isPresent()) {
            this.log().warn("Cannot read clipboard because there is no host.");
            return null;
        }
        SelenoidRestClient client = new SelenoidRestClient(url.get());
        Optional<String> clipboard = client.getClipboard(selenoidSessionId);
        return clipboard.orElse(null);
    }

    public void setClipboard(SessionContext sessionContext, String value) {
        String selenoidSessionId = this.getSelenoidSessionId(sessionContext.getRemoteSessionId());
        Optional<String> url = this.getSelenoidUrl(sessionContext.getNodeInfo());
        if (!url.isPresent()) {
            this.log().warn("Cannot set clipboard because there is no host.");
        } else {
            SelenoidRestClient client = new SelenoidRestClient(url.get());
            client.setClipbard(selenoidSessionId, value);
        }
    }

    private Optional<String> getSelenoidUrl(Optional<NodeInfo> nodeInfo) {
        if (nodeInfo.isPresent()) {
            return Optional.of(String.format("http://%s:%s/", nodeInfo.get().getHost(), nodeInfo.get().getPort()));
        }
        return Optional.empty();
    }

    private String getSelenoidSessionId(Optional<String> optionalremoteSessionId) {
        return optionalremoteSessionId.map(remoteSessionId -> {
            if (remoteSessionId.length() >= 64) {
                remoteSessionId = remoteSessionId.substring(32);
            }
            return remoteSessionId;
        }).orElse(null);
    }
}

