/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testerra.plugins.selenoid.utils;

import eu.tsystems.mms.tic.testframework.logging.Loggable;
import java.util.Optional;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class SelenoidRestClient
implements Loggable {
    private final Client client;
    private final String url;

    public SelenoidRestClient(String url) {
        this.url = url;
        this.client = ClientBuilder.newClient();
    }

    public Optional<String> getHost(String remoteSessionid) {
        Response response = this.getBuilder("/host/" + remoteSessionid).get();
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            this.log().debug("No Selenoid found. (" + response.getStatus() + ")");
            return Optional.empty();
        }
        return Optional.of(response.readEntity(String.class));
    }

    public Optional<String> getPing() {
        Response response = this.getBuilder("/ping").get();
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            this.log().debug("No Selenoid found. (" + response.getStatus() + ")");
            return Optional.empty();
        }
        return Optional.of(response.readEntity(String.class));
    }

    public Optional<String> deleteVideofile(String videoFileName) {
        Response response = this.getBuilder("/video/" + videoFileName).delete();
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            this.log().debug("Cannot delete video file " + videoFileName + "(" + response.getStatus() + ")");
            this.log().debug((String)response.readEntity(String.class));
            return Optional.empty();
        }
        return Optional.of(response.readEntity(String.class));
    }

    public Optional<String> getClipboard(String remoteSessionId) {
        Response response = this.getBuilder("/clipboard/" + remoteSessionId).get();
        String result = (String)response.readEntity(String.class);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            this.log().debug("Cannot read clipboard from session (" + response.getStatus() + ")");
            this.log().debug(result);
            return Optional.empty();
        }
        return Optional.of(result);
    }

    public void setClipbard(String remoteSessionId, String value) {
        Response response = this.getBuilder("/clipboard/" + remoteSessionId).post(Entity.entity((Object)value, (MediaType)MediaType.TEXT_PLAIN_TYPE));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            this.log().debug("Cannot set clipboard to session (" + response.getStatus() + ")");
            this.log().debug((String)response.readEntity(String.class));
        }
    }

    private Invocation.Builder getBuilder(String path) {
        WebTarget webTarget = this.client.target(this.url).path(path);
        this.log().debug(webTarget.getUri().toString());
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        return builder;
    }
}

