/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testerra.plugins.selenoid.webdriver;

import eu.tsystems.mms.tic.testerra.plugins.selenoid.utils.SelenoidProperties;
import eu.tsystems.mms.tic.testerra.plugins.selenoid.webdriver.SelenoidCapabilities;
import eu.tsystems.mms.tic.testframework.common.PropertyManager;
import eu.tsystems.mms.tic.testframework.common.Testerra;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.report.model.context.MethodContext;
import eu.tsystems.mms.tic.testframework.report.utils.DefaultExecutionContextController;
import eu.tsystems.mms.tic.testframework.webdrivermanager.DesktopWebDriverRequest;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverRequest;
import java.util.HashMap;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SelenoidCapabilityProvider
implements Consumer<WebDriverRequest>,
Loggable {
    private final boolean VIDEO_ACTIVE = Testerra.Properties.SCREENCASTER_ACTIVE.asBool();
    private final boolean VNC_ACTIVE = PropertyManager.getBooleanProperty((String)"tt.selenoid.vnc.enabled", (boolean)true);
    private final String VNC_ADDRESS = PropertyManager.getProperty((String)"tt.selenoid.vnc.address", (String)SelenoidProperties.Default.VNC_ADDRESS);
    private static final int VIDEO_FRAMERATE = PropertyManager.getIntProperty((String)"tt.selenoid.video.framerate", (int)2);
    private static final int VIDEO_FRAMERATE_MAX = 15;

    @Override
    public void accept(WebDriverRequest webDriverRequest) {
        if (!(webDriverRequest instanceof DesktopWebDriverRequest)) {
            return;
        }
        if (this.VNC_ACTIVE && StringUtils.isBlank((CharSequence)this.VNC_ADDRESS)) {
            this.log().warn(String.format("%s is set to true, but vnc host property %s was not set.", "tt.selenoid.vnc.enabled", "tt.selenoid.vnc.address"));
        }
        DesktopWebDriverRequest desktopWebDriverRequest = (DesktopWebDriverRequest)webDriverRequest;
        Capabilities videoCaps = this.provide(desktopWebDriverRequest);
        desktopWebDriverRequest.getDesiredCapabilities().merge(videoCaps);
    }

    private Capabilities provide(DesktopWebDriverRequest request) {
        DefaultExecutionContextController contextController = new DefaultExecutionContextController();
        String reportName = contextController.getExecutionContext().getRunConfig().getReportName();
        String runConfigName = contextController.getExecutionContext().getRunConfig().RUNCFG;
        String methodName = ((MethodContext)contextController.getCurrentMethodContext().get()).getName();
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities();
        desiredCapabilities.setCapability(SelenoidCapabilities.ENABLE_VNC, this.VNC_ACTIVE);
        desiredCapabilities.setCapability(SelenoidCapabilities.ENABLE_VIDEO, this.VIDEO_ACTIVE);
        int framerate = Math.max(Math.min(VIDEO_FRAMERATE, 15), 1);
        desiredCapabilities.setCapability(SelenoidCapabilities.VIDEO_FRAME_RATE, (Object)framerate);
        desiredCapabilities.setCapability(SelenoidCapabilities.VIDEO_NAME, this.createVideoName(request.getSessionKey(), reportName, runConfigName));
        Dimension windowSize = request.getWindowSize();
        desiredCapabilities.setCapability(SelenoidCapabilities.SCREEN_RESOLUTION, String.format("%sx%sx24", windowSize.getWidth(), windowSize.getHeight()));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ReportName", reportName);
        map.put("RunConfig", runConfigName);
        map.put("Testmethod", methodName);
        desiredCapabilities.setCapability(SelenoidCapabilities.LABELS, map);
        return desiredCapabilities;
    }

    private String createVideoName(String sessionKey, String reportName, String runConfigName) {
        String videoName = reportName + runConfigName + Thread.currentThread().getId() + sessionKey + System.currentTimeMillis();
        videoName = videoName.replaceAll("[^a-zA-Z0-9]", "");
        return videoName + ".mp4";
    }
}

