/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testerra.plugins.selenoid.webdriver;

import eu.tsystems.mms.tic.testerra.plugins.selenoid.request.VideoRequest;
import eu.tsystems.mms.tic.testerra.plugins.selenoid.request.VideoRequestStorage;
import eu.tsystems.mms.tic.testerra.plugins.selenoid.utils.SelenoidHelper;
import eu.tsystems.mms.tic.testerra.plugins.selenoid.webdriver.SelenoidCapabilities;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.report.model.context.SessionContext;
import eu.tsystems.mms.tic.testframework.testing.WebDriverManagerProvider;
import eu.tsystems.mms.tic.testframework.webdrivermanager.WebDriverRequest;
import java.net.URL;
import java.util.function.Consumer;
import org.openqa.selenium.WebDriver;

public class VideoDesktopWebDriverFactory
implements Loggable,
Consumer<WebDriver>,
WebDriverManagerProvider {
    private final SelenoidHelper selenoidHelper = SelenoidHelper.get();
    private final VideoRequestStorage videoRequestStorage = VideoRequestStorage.get();

    @Override
    public void accept(WebDriver webDriver) {
        WEB_DRIVER_MANAGER.getSessionContext(webDriver).ifPresent(sessionContext -> {
            WebDriverRequest webDriverRequest = sessionContext.getWebDriverRequest();
            sessionContext.getRemoteSessionId().ifPresent(remoteSessionId -> webDriverRequest.getServerUrl().ifPresent(url -> {
                if (this.selenoidHelper.updateNodeInfo((URL)url, (String)remoteSessionId, (SessionContext)sessionContext)) {
                    VideoRequest videoRequest = new VideoRequest((SessionContext)sessionContext, webDriverRequest.getCapabilities().get(SelenoidCapabilities.VIDEO_NAME).toString());
                    this.videoRequestStorage.store(videoRequest);
                    this.log().info("VNC Streaming URL: " + this.selenoidHelper.getRemoteVncUrl(videoRequest, (String)remoteSessionId));
                }
            }));
        });
    }
}

