/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.extractor.strategy;

import io.testomat.junit.exception.ParameterExtractionException;
import io.testomat.junit.extractor.strategy.ParameterExtractionContext;
import io.testomat.junit.extractor.strategy.ParameterHandlerRegistry;
import io.testomat.junit.extractor.strategy.handlers.ParameterExtractionHandler;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterExtractorService {
    private static final Logger logger = LoggerFactory.getLogger(ParameterExtractorService.class);
    private final ParameterHandlerRegistry handlerRegistry;

    public ParameterExtractorService() {
        this.handlerRegistry = new ParameterHandlerRegistry();
    }

    public ParameterExtractorService(ParameterHandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    public Object extractParameters(ExtensionContext extensionContext) {
        if (extensionContext == null) {
            return null;
        }
        ParameterExtractionContext context = new ParameterExtractionContext(extensionContext);
        if (!context.isValid()) {
            return null;
        }
        Optional<ParameterExtractionHandler> handler = this.handlerRegistry.findHandler(context);
        if (!handler.isPresent()) {
            logger.debug("No applicable handler found for test: {}", (Object)context.getDisplayName());
            return null;
        }
        ParameterExtractionHandler strategy = handler.get();
        try {
            Object result = strategy.extractParameters(context);
            logger.debug("Successfully extracted parameters using {}: {}", (Object)strategy.getStrategyName(), (Object)context.getDisplayName());
            return result;
        }
        catch (ParameterExtractionException e) {
            logger.warn("Parameter extraction failed with {}: {}", (Object)strategy.getStrategyName(), (Object)e.getMessage());
            return null;
        }
    }

    public ParameterHandlerRegistry getHandlerRegistry() {
        return this.handlerRegistry;
    }
}

