/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.extractor.strategy;

import io.testomat.junit.extractor.strategy.ParameterExtractionContext;
import io.testomat.junit.extractor.strategy.handlers.ArgumentsSourceHandler;
import io.testomat.junit.extractor.strategy.handlers.CsvFileSourceHandler;
import io.testomat.junit.extractor.strategy.handlers.CsvSourceHandler;
import io.testomat.junit.extractor.strategy.handlers.EmptySourceHandler;
import io.testomat.junit.extractor.strategy.handlers.EnumSourceHandler;
import io.testomat.junit.extractor.strategy.handlers.MethodSourceHandler;
import io.testomat.junit.extractor.strategy.handlers.NullAndEmptySourceHandler;
import io.testomat.junit.extractor.strategy.handlers.NullSourceHandler;
import io.testomat.junit.extractor.strategy.handlers.ParameterExtractionHandler;
import io.testomat.junit.extractor.strategy.handlers.ValueSourceHandler;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.CsvFileSource;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.EmptySource;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullAndEmptySource;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

public final class ParameterHandlerRegistry {
    private final Map<Class<? extends Annotation>, ParameterExtractionHandler> handlerMap;

    public ParameterHandlerRegistry() {
        this.handlerMap = new HashMap<Class<? extends Annotation>, ParameterExtractionHandler>();
        this.registerDefaultHandlers();
    }

    public ParameterHandlerRegistry(Map<Class<? extends Annotation>, ParameterExtractionHandler> customHandlers) {
        this.handlerMap = new HashMap<Class<? extends Annotation>, ParameterExtractionHandler>(customHandlers);
    }

    public Optional<ParameterExtractionHandler> findHandler(ParameterExtractionContext context) {
        if (!context.isValid()) {
            return Optional.empty();
        }
        ParameterExtractionHandler foundHandler = null;
        Class<? extends Annotation> foundAnnotation = null;
        for (Annotation annotation : context.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            ParameterExtractionHandler handler = this.handlerMap.get(annotationType);
            if (handler == null) continue;
            if (foundHandler != null) {
                throw new IllegalStateException(String.format("Multiple parameter source annotations found on method: @%s and @%s. Only one parameter source annotation is allowed method.", foundAnnotation.getSimpleName(), annotationType.getSimpleName()));
            }
            foundHandler = handler;
            foundAnnotation = annotationType;
        }
        return Optional.ofNullable(foundHandler);
    }

    private void registerDefaultHandlers() {
        this.handlerMap.put(ValueSource.class, new ValueSourceHandler());
        this.handlerMap.put(EnumSource.class, new EnumSourceHandler());
        this.handlerMap.put(CsvSource.class, new CsvSourceHandler());
        this.handlerMap.put(CsvFileSource.class, new CsvFileSourceHandler());
        this.handlerMap.put(MethodSource.class, new MethodSourceHandler());
        this.handlerMap.put(ArgumentsSource.class, new ArgumentsSourceHandler());
        this.handlerMap.put(NullAndEmptySource.class, new NullAndEmptySourceHandler());
        this.handlerMap.put(NullSource.class, new NullSourceHandler());
        this.handlerMap.put(EmptySource.class, new EmptySourceHandler());
    }
}

