/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.extractor.strategy.handlers;

import io.testomat.junit.extractor.strategy.ParameterExtractionContext;
import io.testomat.junit.extractor.strategy.handlers.AbstractParameterExtractionHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.junit.jupiter.params.provider.EnumSource;

public class EnumSourceHandler
extends AbstractParameterExtractionHandler {
    @Override
    public String getStrategyName() {
        return "EnumSourceExtractionStrategy";
    }

    @Override
    protected Object parseDisplayNameValue(String valueStr, ParameterExtractionContext context) {
        return this.parseEnumValue(valueStr, context);
    }

    @Override
    protected Object extractFromAnnotation(ParameterExtractionContext context) {
        EnumSource enumSource = context.getAnnotation(EnumSource.class);
        if (enumSource == null) {
            return null;
        }
        try {
            Class<Enum<?>> enumClass = enumSource.value();
            if (enumClass.getName().equals("org.junit.jupiter.params.provider.NullEnum")) {
                enumClass = this.inferEnumClassFromMethod(context);
            }
            if (enumClass == null) {
                return null;
            }
            Enum<?>[] enumConstants = enumClass.getEnumConstants();
            if (enumConstants == null || enumConstants.length == 0) {
                return null;
            }
            String[] names = enumSource.names();
            if (names.length > 0) {
                for (String name : names) {
                    try {
                        return Enum.valueOf(enumClass, name);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.warn("Could not find enum constant {}", (Object)name);
                    }
                }
                return null;
            }
            return enumConstants[0];
        }
        catch (Exception e) {
            this.logger.debug("Failed to extract enum from annotation", (Throwable)e);
            return null;
        }
    }

    private Class<? extends Enum<?>> inferEnumClassFromMethod(ParameterExtractionContext context) {
        Method method = context.getTestMethod();
        if (method == null) {
            return null;
        }
        Parameter[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return null;
        }
        Class<?> paramType = parameters[0].getType();
        if (paramType.isEnum()) {
            return paramType;
        }
        return null;
    }

    private Object parseEnumValue(String value, ParameterExtractionContext context) {
        if (value == null || value.trim().isEmpty()) {
            return value;
        }
        String trimmed = value.trim();
        if ("null".equals(trimmed)) {
            return null;
        }
        try {
            EnumSource enumSource = context.getAnnotation(EnumSource.class);
            Class<Enum<?>> enumClass = enumSource.value();
            if (enumClass.getName().equals("org.junit.jupiter.params.provider.NullEnum")) {
                enumClass = this.inferEnumClassFromMethod(context);
            }
            if (enumClass != null) {
                String enumName = trimmed;
                if (trimmed.contains(".")) {
                    enumName = trimmed.substring(trimmed.lastIndexOf(46) + 1);
                }
                return Enum.valueOf(enumClass, enumName);
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed to parse enum value: {}", (Object)trimmed, (Object)e);
        }
        return value;
    }
}

