/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.extractor.strategy.handlers.util;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsvParsingUtils {
    private static final Logger logger = LoggerFactory.getLogger(CsvParsingUtils.class);

    private CsvParsingUtils() {
    }

    public static Object[] parseCsvString(String csvString, String delimiter, char quoteCharacter, String[] nullValuesArray) {
        if (csvString == null || csvString.trim().isEmpty()) {
            return new Object[0];
        }
        try {
            String actualDelimiter = delimiter == null || delimiter.equals("\u0000") ? "," : delimiter;
            List<String> values = CsvParsingUtils.smartCsvSplit(csvString, actualDelimiter, quoteCharacter);
            Object[] result = new Object[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                result[i] = CsvParsingUtils.processValue(values.get(i), nullValuesArray);
            }
            return result;
        }
        catch (Exception e) {
            logger.debug("Failed to parse CSV string: {}", (Object)csvString, (Object)e);
            return csvString.split(",");
        }
    }

    public static Object[] parseCommaSeparatedValues(String content) {
        if (content == null || content.trim().isEmpty()) {
            return new Object[0];
        }
        String[] parts = content.split(",");
        Object[] result = new Object[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim();
            result[i] = CsvParsingUtils.parseTypedValue(part);
        }
        return result;
    }

    private static List<String> smartCsvSplit(String input, String delimiter, char quoteCharacter) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == quoteCharacter) {
                if (inQuotes && i + 1 < input.length() && input.charAt(i + 1) == quoteCharacter) {
                    current.append(quoteCharacter);
                    ++i;
                    continue;
                }
                inQuotes = !inQuotes;
                continue;
            }
            if (!inQuotes && CsvParsingUtils.matchesDelimiter(input, i, delimiter)) {
                result.add(current.toString().trim());
                current.setLength(0);
                i += delimiter.length() - 1;
                continue;
            }
            current.append(c);
        }
        result.add(current.toString().trim());
        return result;
    }

    private static boolean matchesDelimiter(String input, int position, String delimiter) {
        if (position + delimiter.length() > input.length()) {
            return false;
        }
        return input.startsWith(delimiter, position);
    }

    private static Object processValue(String value, String[] nullValuesArray) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        if (trimmed.length() >= 2 && (trimmed.startsWith("\"") && trimmed.endsWith("\"") || trimmed.startsWith("'") && trimmed.endsWith("'"))) {
            trimmed = trimmed.substring(1, trimmed.length() - 1);
        }
        if (nullValuesArray != null) {
            for (String nullValue : nullValuesArray) {
                if (!trimmed.equals(nullValue)) continue;
                return null;
            }
        }
        if ("null".equals(trimmed) || "NULL".equals(trimmed)) {
            return null;
        }
        return CsvParsingUtils.parseTypedValue(trimmed);
    }

    private static Object parseTypedValue(String value) {
        if (value == null || value.trim().isEmpty()) {
            return value;
        }
        String trimmed = value.trim();
        if ("true".equalsIgnoreCase(trimmed)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmed)) {
            return false;
        }
        try {
            if (trimmed.contains(".")) {
                return Double.parseDouble(trimmed);
            }
            long longVal = Long.parseLong(trimmed);
            if (longVal >= Integer.MIN_VALUE && longVal <= Integer.MAX_VALUE) {
                return (int)longVal;
            }
            return longVal;
        }
        catch (NumberFormatException e) {
            logger.warn("Failed to parse double value: {}", (Object)value, (Object)e);
            return value;
        }
    }
}

