/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.methodexporter.extractors;

import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LabelExtractor {
    private static final String COMMENT_LABEL_PATTERN = "@(\\w+)(?::(\\w+))?|#(\\w+)";

    public List<String> extractLabels(MethodDeclaration testMethod) {
        try {
            ArrayList<String> labels = new ArrayList<String>();
            this.extractAnnotationLabels(testMethod, labels);
            this.extractCommentLabels(testMethod, labels);
            this.extractNamePatternLabels(testMethod, labels);
            return labels;
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    private void extractAnnotationLabels(MethodDeclaration testMethod, List<String> labels) {
        block28: for (AnnotationExpr annotation : testMethod.getAnnotations()) {
            String annName;
            switch (annName = annotation.getNameAsString()) {
                case "Test": {
                    labels.add("unit");
                    continue block28;
                }
                case "IntegrationTest": 
                case "SpringBootTest": {
                    labels.add("integration");
                    continue block28;
                }
                case "ParameterizedTest": {
                    labels.add("parameterized");
                    continue block28;
                }
                case "RepeatedTest": {
                    labels.add("repeated");
                    continue block28;
                }
                case "TestFactory": {
                    labels.add("dynamic");
                    continue block28;
                }
                case "Disabled": 
                case "Ignore": {
                    labels.add("disabled");
                    continue block28;
                }
                case "Timeout": {
                    labels.add("timeout");
                    continue block28;
                }
                case "WebMvcTest": {
                    labels.add("web");
                    continue block28;
                }
                case "DataJpaTest": {
                    labels.add("jpa");
                    continue block28;
                }
                case "JsonTest": {
                    labels.add("json");
                    continue block28;
                }
                case "Tag": {
                    String tagValue = this.getAnnotationValue(annotation);
                    if (tagValue == null) continue block28;
                    labels.add(tagValue);
                    continue block28;
                }
            }
            if (!annName.endsWith("Test")) continue;
            labels.add(annName.toLowerCase().replace("test", ""));
        }
    }

    private void extractCommentLabels(MethodDeclaration testMethod, List<String> labels) {
        testMethod.getComment().ifPresent(comment -> {
            String text = comment.getContent();
            Pattern pattern = Pattern.compile(COMMENT_LABEL_PATTERN);
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                if (matcher.group(3) != null) {
                    labels.add(matcher.group(3));
                    continue;
                }
                String tag = matcher.group(1);
                String value = matcher.group(2);
                labels.add((String)(value != null ? tag + ":" + value : tag));
            }
        });
    }

    private void extractNamePatternLabels(MethodDeclaration testMethod, List<String> labels) {
        String methodName = testMethod.getNameAsString().toLowerCase();
        if (methodName.contains("integration")) {
            labels.add("integration");
        }
        if (methodName.contains("smoke")) {
            labels.add("smoke");
        }
        if (methodName.contains("performance")) {
            labels.add("performance");
        }
    }

    public String getAnnotationValue(AnnotationExpr annotation) {
        if (annotation instanceof SingleMemberAnnotationExpr) {
            return ((SingleMemberAnnotationExpr)annotation).getMemberValue().asStringLiteralExpr().getValue();
        }
        if (annotation instanceof NormalAnnotationExpr) {
            return ((NormalAnnotationExpr)annotation).getPairs().stream().filter(pair -> "value".equals(pair.getNameAsString())).findFirst().map(pair -> pair.getValue().asStringLiteralExpr().getValue()).orElse(null);
        }
        return null;
    }
}

