/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.methodexporter.filefinder;

import io.testomat.junit.exception.MethodExporterException;
import io.testomat.junit.methodexporter.filefinder.PathNormalizer;
import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileFinder {
    private static final Logger log = LoggerFactory.getLogger(FileFinder.class);
    private static final String FILE_SEPARATOR = FileSystems.getDefault().getSeparator();
    private final PathNormalizer normalizer;

    public FileFinder() {
        this.normalizer = new PathNormalizer();
    }

    public FileFinder(PathNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    public String getTestClassFilePath(Class<?> testClass) {
        String[] sourceDirs;
        if (testClass == null) {
            return null;
        }
        String className = testClass.getName();
        String packagePath = className.replace('.', '/');
        String fileName = packagePath + ".java";
        for (String sourceDir : sourceDirs = new String[]{"src/test/java/", "src/main/java/", "test/", "src/"}) {
            String fullPath = sourceDir + fileName;
            if (!new File(fullPath).exists()) continue;
            return fullPath;
        }
        return "src/test/java/" + fileName;
    }

    public String getPath(ExtensionContext context) {
        try {
            Class testClass = (Class)context.getTestClass().orElseThrow(() -> new MethodExporterException("No test class found"));
            URI uri = testClass.getProtectionDomain().getCodeSource().getLocation().toURI();
            return URLDecoder.decode(uri.getPath(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.debug("Error getting path from context: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public String extractRelativeFilePath(String filepath) {
        try {
            int javaIndex;
            if (filepath == null || filepath.isEmpty()) {
                return "UnknownFile.java";
            }
            String normalizedPath = this.normalizer.normalizePath(filepath);
            if (normalizedPath.contains("src/test/java/")) {
                int index = normalizedPath.indexOf("src/test/java/");
                return normalizedPath.substring(index + "src/test/java/".length());
            }
            if (normalizedPath.contains("src/main/java/")) {
                int index = normalizedPath.indexOf("src/main/java/");
                return normalizedPath.substring(index + "src/main/java/".length());
            }
            if (normalizedPath.contains("src/") && normalizedPath.contains("/java/") && (javaIndex = normalizedPath.lastIndexOf("/java/")) != -1) {
                return normalizedPath.substring(javaIndex + "/java/".length());
            }
            if (!normalizedPath.contains("/") || normalizedPath.matches("^[a-zA-Z0-9._/]+\\.java$")) {
                return normalizedPath;
            }
            return normalizedPath;
        }
        catch (Exception e) {
            log.debug("Error extracting relative file path: {}", (Object)e.getMessage(), (Object)e);
            return "UnknownFile.java";
        }
    }
}

