/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.reporter;

import io.testomat.core.exception.ReportTestResultException;
import io.testomat.core.model.TestMetadata;
import io.testomat.core.model.TestResult;
import io.testomat.core.runmanager.GlobalRunManager;
import io.testomat.junit.constructor.JUnitTestResultConstructor;
import io.testomat.junit.extractor.JunitMetaDataExtractor;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JunitTestReporter {
    private static final Logger log = LoggerFactory.getLogger(JunitTestReporter.class);
    private final JUnitTestResultConstructor resultConstructor;
    private final JunitMetaDataExtractor metaDataExtractor;
    private final GlobalRunManager runManager;
    private final ConcurrentHashMap<String, ReentrantLock> testLocks;

    public JunitTestReporter() {
        this.metaDataExtractor = new JunitMetaDataExtractor();
        this.resultConstructor = new JUnitTestResultConstructor(this.metaDataExtractor);
        this.runManager = GlobalRunManager.getInstance();
        this.testLocks = new ConcurrentHashMap();
    }

    public JunitTestReporter(JUnitTestResultConstructor resultConstructor, JunitMetaDataExtractor metaDataExtractor, GlobalRunManager runManager) {
        this.resultConstructor = Objects.requireNonNull(resultConstructor, "resultConstructor cannot be null");
        this.metaDataExtractor = Objects.requireNonNull(metaDataExtractor, "metaDataExtractor cannot be null");
        this.runManager = Objects.requireNonNull(runManager, "runManager cannot be null");
        this.testLocks = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportTestResult(ExtensionContext context, String status, String message) {
        Objects.requireNonNull(context, "ExtensionContext cannot be null");
        if (!this.runManager.isActive()) {
            log.debug("Run manager is not active, skipping test result reporting for: {}", (Object)context.getDisplayName());
            return;
        }
        String lockKey = this.generateLockKey(context);
        ReentrantLock lock = this.testLocks.computeIfAbsent(lockKey, k -> new ReentrantLock());
        lock.lock();
        try {
            this.doReportTestResult(context, status, message);
        }
        finally {
            lock.unlock();
            this.cleanupLockIfUnused(lockKey, lock);
        }
    }

    private void doReportTestResult(ExtensionContext context, String status, String message) {
        TestMetadata metadata = null;
        try {
            metadata = this.metaDataExtractor.extractTestMetadata(context);
            TestResult result = this.resultConstructor.constructTestRunResult(metadata, message, status, context);
            log.debug("Reporting test result: title='{}', status='{}', rid='{}'", new Object[]{result.getTitle(), status, result.getRid()});
            this.runManager.reportTest(result);
            log.info("Successfully reported test result for: {} with status: {}", (Object)result.getTitle(), (Object)status);
        }
        catch (Exception e) {
            String testName = metadata != null ? metadata.getTitle() : context.getDisplayName();
            String errorMessage = String.format("Failed to report test result for: %s (uniqueId: %s)", testName, context.getUniqueId());
            log.error(errorMessage, (Throwable)e);
            throw new ReportTestResultException(errorMessage, (Throwable)e);
        }
    }

    private String generateLockKey(ExtensionContext context) {
        String uniqueId = context.getUniqueId();
        long timestamp = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        return String.format("%s-t%d-n%d", uniqueId, threadId, timestamp);
    }

    private void cleanupLockIfUnused(String lockKey, ReentrantLock lock) {
        if (!lock.hasQueuedThreads()) {
            this.testLocks.remove(lockKey);
        }
    }
}

