/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.constructor;

import io.testomat.core.model.ExceptionDetails;
import io.testomat.core.model.TestMetadata;
import io.testomat.core.model.TestResult;
import io.testomat.junit.exception.ReporterException;
import io.testomat.junit.extractor.JunitMetaDataExtractor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.opentest4j.TestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitTestResultConstructor {
    private static final Logger log = LoggerFactory.getLogger(JUnitTestResultConstructor.class);
    private static final Pattern TESTOMAT_API_KEY_PATTERN = Pattern.compile("\\btstmt_[a-zA-Z0-9_-]+", 2);
    private static final Pattern WINDOWS_PATH_PATTERN = Pattern.compile("[C-Z]:\\\\[^\\s]+\\\\([^\\\\\\s]+)");
    private static final Pattern UNIX_PATH_PATTERN = Pattern.compile("/[^\\s]+/([^/\\s]+)");
    private final JunitMetaDataExtractor metaDataExtractor;

    public JUnitTestResultConstructor() {
        this.metaDataExtractor = new JunitMetaDataExtractor();
    }

    public JUnitTestResultConstructor(JunitMetaDataExtractor metaDataExtractor) {
        this.metaDataExtractor = Objects.requireNonNull(metaDataExtractor, "metaDataExtractor cannot be null");
    }

    public TestResult constructTestRunResult(TestMetadata metadata, String message, String status, ExtensionContext context) {
        String stack;
        Objects.requireNonNull(metadata, "metadata cannot be null");
        Objects.requireNonNull(status, "status cannot be null");
        Objects.requireNonNull(context, "context cannot be null");
        Object example = null;
        String rid = null;
        if (this.metaDataExtractor.isParameterizedTest(context)) {
            example = this.metaDataExtractor.extractTestParameters(context);
            rid = context.getUniqueId();
            log.debug("Parameterized test - example: {}, rid: {}", example, (Object)rid);
        }
        if (message != null) {
            stack = this.extractStackTrace(context);
        } else {
            ExceptionDetails details = this.extractExceptionDetails(context);
            message = details.getMessage();
            stack = details.getStack();
        }
        return this.createTestResult(metadata, message, status, stack, example, rid);
    }

    private TestResult createTestResult(TestMetadata metadata, String message, String status, String stack, Object example, String rid) {
        Objects.requireNonNull(metadata, "metadata cannot be null");
        TestResult.Builder builder = TestResult.builder().withSuiteTitle(metadata.getSuiteTitle()).withTestId(metadata.getTestId()).withTitle(metadata.getTitle()).withFile(metadata.getFile()).withMessage(message).withStatus(status).withStack(stack);
        if (example != null) {
            builder.withExample(example);
        }
        if (rid != null) {
            builder.withRid(rid);
        }
        return builder.build();
    }

    private ExceptionDetails extractExceptionDetails(ExtensionContext context) {
        return this.extractReportableException(context).map(this::createExceptionDetails).orElse(ExceptionDetails.empty());
    }

    private String extractStackTrace(ExtensionContext context) {
        return this.extractReportableException(context).map(this::getStackTrace).orElse(null);
    }

    private Optional<Throwable> extractReportableException(ExtensionContext context) {
        return context.getExecutionException().filter(this::isReportableException);
    }

    private ExceptionDetails createExceptionDetails(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable cannot be null");
        String message = this.sanitizeSensitiveContent(throwable.getMessage());
        String stack = this.getStackTrace(throwable);
        return new ExceptionDetails(message, stack);
    }

    private String sanitizeSensitiveContent(String text) {
        if (text == null) {
            return null;
        }
        String sanitized = text;
        sanitized = TESTOMAT_API_KEY_PATTERN.matcher(sanitized).replaceAll("tstmt_***");
        sanitized = WINDOWS_PATH_PATTERN.matcher(sanitized).replaceAll("$1");
        sanitized = UNIX_PATH_PATTERN.matcher(sanitized).replaceAll("$1");
        return sanitized;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getStackTrace(Throwable throwable) {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                throwable.printStackTrace(pw);
                String rawStackTrace = sw.toString();
                String string = this.sanitizeSensitiveContent(rawStackTrace);
                pw.close();
                return string;
            }
            catch (Throwable throwable2) {
                try {
                    pw.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Exception e) {
            throw new ReporterException("Failed to get stack trace", e);
        }
    }

    private boolean isReportableException(Throwable throwable) {
        return !(Objects.requireNonNull(throwable) instanceof TestAbortedException);
    }
}

