/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.extractor.strategy;

import io.testomat.junit.extractor.strategy.SourceCodeParameterNameResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ParameterExtractionContext {
    private final ExtensionContext extensionContext;
    private final Method testMethod;
    private final Annotation[] annotations;
    private final String displayName;
    private final String uniqueId;
    private final SourceCodeParameterNameResolver parameterNameResolver;

    public ParameterExtractionContext(ExtensionContext extensionContext) {
        this(extensionContext, SourceCodeParameterNameResolver.getInstance());
    }

    ParameterExtractionContext(ExtensionContext extensionContext, SourceCodeParameterNameResolver parameterNameResolver) {
        this.extensionContext = extensionContext;
        this.testMethod = extensionContext.getTestMethod().orElse(null);
        this.annotations = this.testMethod != null ? this.testMethod.getAnnotations() : new Annotation[]{};
        this.displayName = extensionContext.getDisplayName();
        this.uniqueId = extensionContext.getUniqueId();
        this.parameterNameResolver = parameterNameResolver;
    }

    public ExtensionContext getExtensionContext() {
        return this.extensionContext;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    public Annotation[] getAnnotations() {
        return (Annotation[])this.annotations.clone();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        if (this.testMethod == null) {
            return false;
        }
        return this.testMethod.isAnnotationPresent(annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        if (this.testMethod == null) {
            return null;
        }
        return this.testMethod.getAnnotation(annotationType);
    }

    public boolean isValid() {
        return this.testMethod != null && this.extensionContext != null;
    }

    public String getParameterName(int parameterIndex) {
        if (this.testMethod == null) {
            return "param" + parameterIndex;
        }
        return this.parameterNameResolver.getParameterName(this.testMethod, parameterIndex);
    }
}

