/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.extractor.strategy;

import io.testomat.junit.extractor.strategy.ParameterExtractionContext;
import io.testomat.junit.extractor.strategy.handlers.ArgumentsSourceHandler;
import io.testomat.junit.extractor.strategy.handlers.CsvFileSourceHandler;
import io.testomat.junit.extractor.strategy.handlers.CsvSourceHandler;
import io.testomat.junit.extractor.strategy.handlers.EmptySourceHandler;
import io.testomat.junit.extractor.strategy.handlers.EnumSourceHandler;
import io.testomat.junit.extractor.strategy.handlers.MethodSourceHandler;
import io.testomat.junit.extractor.strategy.handlers.NullAndEmptySourceHandler;
import io.testomat.junit.extractor.strategy.handlers.NullSourceHandler;
import io.testomat.junit.extractor.strategy.handlers.ParameterExtractionHandler;
import io.testomat.junit.extractor.strategy.handlers.ValueSourceHandler;
import io.testomat.junit.util.ParameterizedTestSupport;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class ParameterHandlerRegistry {
    private final Map<Class<? extends Annotation>, ParameterExtractionHandler> handlerMap;

    public ParameterHandlerRegistry() {
        this.handlerMap = new HashMap<Class<? extends Annotation>, ParameterExtractionHandler>();
        this.registerDefaultHandlers();
    }

    public ParameterHandlerRegistry(Map<Class<? extends Annotation>, ParameterExtractionHandler> customHandlers) {
        this.handlerMap = new HashMap<Class<? extends Annotation>, ParameterExtractionHandler>(customHandlers);
    }

    public Optional<ParameterExtractionHandler> findHandler(ParameterExtractionContext context) {
        if (!context.isValid() || !ParameterizedTestSupport.isAvailable()) {
            return Optional.empty();
        }
        ParameterExtractionHandler foundHandler = null;
        Class<? extends Annotation> foundAnnotation = null;
        for (Annotation annotation : context.getAnnotations()) {
            Class<? extends Annotation> annotationType;
            ParameterExtractionHandler handler;
            if (!ParameterizedTestSupport.isJunitParamsAnnotation(annotation) || (handler = this.handlerMap.get(annotationType = annotation.annotationType())) == null) continue;
            if (foundHandler != null) {
                throw new IllegalStateException(String.format("Multiple parameter source annotations found on method: @%s and @%s. Only one parameter source annotation is allowed method.", foundAnnotation.getSimpleName(), annotationType.getSimpleName()));
            }
            foundHandler = handler;
            foundAnnotation = annotationType;
        }
        return Optional.ofNullable(foundHandler);
    }

    private void registerDefaultHandlers() {
        if (!ParameterizedTestSupport.isAvailable()) {
            return;
        }
        this.registerHandler("ValueSource", new ValueSourceHandler());
        this.registerHandler("EnumSource", new EnumSourceHandler());
        this.registerHandler("CsvSource", new CsvSourceHandler());
        this.registerHandler("CsvFileSource", new CsvFileSourceHandler());
        this.registerHandler("MethodSource", new MethodSourceHandler());
        this.registerHandler("ArgumentsSource", new ArgumentsSourceHandler());
        this.registerHandler("NullAndEmptySource", new NullAndEmptySourceHandler());
        this.registerHandler("NullSource", new NullSourceHandler());
        this.registerHandler("EmptySource", new EmptySourceHandler());
    }

    private void registerHandler(String annotationName, ParameterExtractionHandler handler) {
        ParameterizedTestSupport.loadAnnotationClass(annotationName).ifPresent(annotationClass -> this.handlerMap.put((Class<? extends Annotation>)annotationClass, handler));
    }
}

